/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.impl.handlers.AbstractRequestController;
import com.marklogic.xcc.impl.handlers.GoodQueryResponseHandler;
import com.marklogic.xcc.impl.handlers.NotFoundCodeHandler;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import com.marklogic.xcc.impl.handlers.ServerExceptionHandler;
import com.marklogic.xcc.impl.handlers.ServiceUnavailableHandler;
import com.marklogic.xcc.impl.handlers.UnauthorizedHandler;
import com.marklogic.xcc.impl.handlers.UnrecognizedCodeHandler;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EvalRequestController
extends AbstractRequestController {
    private static final Map<Integer, ResponseHandler> handlers = new HashMap<Integer, ResponseHandler>(8);
    protected final String body;
    private final String path;

    public EvalRequestController(String path, String body) {
        super(handlers);
        this.path = path;
        this.body = body;
    }

    @Override
    public ResultSequence serverDialog(ServerConnection connection, Request request, RequestOptions options, Logger logger) throws IOException, RequestException {
        SessionImpl session = (SessionImpl)request.getSession();
        byte[] bodyBytes = this.body.getBytes("UTF-8");
        HttpChannel http = this.buildChannel(connection, this.path, session, options, bodyBytes.length, logger);
        this.issueRequest(http, bodyBytes, logger);
        int code = http.getResponseCode();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("response: " + code + " (" + http.getResponseMessage() + ")");
        }
        this.setConnectionTimeout(connection, http);
        String connectionClose = http.getResponseConnection();
        if (connectionClose != null && connectionClose.equalsIgnoreCase("close")) {
            connection.setTimeoutTime(0L);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Connection:closed header seen. Set connection timeout to 0...");
            }
        }
        session.setServerVersion(http.getServerVersion());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("server version: " + session.getServerVersion());
        }
        if (!session.readCookieValues(http)) {
            String version = session.getServerVersion();
            throw new RequestServerException("Incompatible server version " + version == null ? "" : version + ".  Make sure to set xcc.txn.compatible to true", request);
        }
        if (http.getResponseMessage().contains("Module Not Found")) {
            return (ResultSequence)this.findHandler(500).handleResponse(http, code, request, connection, logger);
        }
        return (ResultSequence)this.findHandler(code).handleResponse(http, code, request, connection, logger);
    }

    @Override
    protected long interTryDelay(long delay, int currentTry) {
        if (currentTry == 0 || delay <= 0L) {
            return 0L;
        }
        return delay;
    }

    private HttpChannel buildChannel(ServerConnection connection, String path, SessionImpl session, RequestOptions options, int bodyLength, Logger logger) {
        String method = "POST";
        HttpChannel http = new HttpChannel(connection.channel(), method, path, bodyLength, options.getTimeoutMillis(), logger);
        http.setRequestContentType("application/x-www-form-urlencoded");
        this.addCommonHeaders(http, session, method, path, options, logger);
        if (bodyLength > http.getBufferSize() && HttpChannel.isUseHTTP()) {
            http.setRequestHeader("Transfer-Encoding", "chunked");
        } else {
            http.setCloseOutputIfNoContentLength(true);
        }
        return http;
    }

    private void issueRequest(HttpChannel http, byte[] encodedQueryBytes, Logger logger) throws IOException {
        boolean isChunked;
        if (logger.isLoggable(Level.FINE)) {
            int kMAX_QUERY_SIZE = 10240;
            int len = encodedQueryBytes.length;
            if (len < 10240) {
                logger.fine("encoded query: " + new String(encodedQueryBytes, "UTF-8"));
            } else {
                logger.fine("encoded query [" + (len - 10240) + " bytes truncated]: " + new String(encodedQueryBytes, 0, 10240, "UTF-8"));
            }
        }
        int bufSize = http.getBufferSize();
        int offset = 0;
        int remaining = encodedQueryBytes.length;
        boolean bl = isChunked = remaining > bufSize && HttpChannel.isUseHTTP();
        while (remaining > 0) {
            int length = Math.min(remaining, bufSize);
            if (isChunked) {
                this.writeChunkHeader(http, 0, length, logger);
            }
            http.write(encodedQueryBytes, offset, length);
            if (isChunked) {
                http.write("\r\n".getBytes(StandardCharsets.US_ASCII));
            }
            remaining -= length;
            offset += length;
        }
        if (isChunked) {
            this.writeChunkHeader(http, 0, 0, logger);
        }
    }

    static {
        EvalRequestController.addDefaultHandler(handlers, new UnrecognizedCodeHandler());
        EvalRequestController.addHandler(handlers, 503, new ServiceUnavailableHandler());
        EvalRequestController.addHandler(handlers, 502, new ServiceUnavailableHandler());
        EvalRequestController.addHandler(handlers, 504, new ServiceUnavailableHandler());
        EvalRequestController.addHandler(handlers, 500, new ServerExceptionHandler());
        EvalRequestController.addHandler(handlers, 401, new UnauthorizedHandler());
        EvalRequestController.addHandler(handlers, 404, new NotFoundCodeHandler());
        EvalRequestController.addHandler(handlers, 400, new NotFoundCodeHandler());
        EvalRequestController.addHandler(handlers, 200, new GoodQueryResponseHandler());
    }
}

