/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.jndi;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class ContentSourceBeanFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String host = null;
        int port = 0;
        String user = null;
        String password = null;
        String contentBase = null;
        URI url = null;
        boolean authenticationPreemptive = false;
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> addrs = ref.getAll();
            while (addrs.hasMoreElements()) {
                RefAddr addr = addrs.nextElement();
                String attrName = addr.getType();
                String attrValue = (String)addr.getContent();
                host = attrName.equals("host") ? attrValue : host;
                user = attrName.equals("user") ? attrValue : user;
                password = attrName.equals("password") ? attrValue : password;
                authenticationPreemptive = attrName.equals("authenticationPreemptive") ? "true".equals(attrValue) : authenticationPreemptive;
                contentBase = attrName.equals("contentBase") ? attrValue : contentBase;
                try {
                    url = attrName.equals("url") ? new URI(attrValue) : url;
                }
                catch (URISyntaxException e) {
                    throw new NamingException("Bad URL: " + attrValue);
                }
                try {
                    port = attrName.equals("port") ? Integer.parseInt(attrValue) : port;
                }
                catch (NumberFormatException e) {
                    throw new NamingException("Invalid port value " + attrValue);
                }
            }
        } else if (environment != null && environment.size() > 0) {
            host = environment.containsKey("host") ? (String)environment.get("host") : host;
            user = environment.containsKey("user") ? (String)environment.get("user") : user;
            password = environment.containsKey("password") ? (String)environment.get("password") : password;
            authenticationPreemptive = environment.containsKey("authenticationPreemptive") ? "true".equals(environment.get("authenticationPreemptive")) : authenticationPreemptive;
            contentBase = environment.containsKey("contentBase") ? (String)environment.get("contentBase") : contentBase;
            try {
                url = environment.containsKey("url") ? new URI((String)environment.get("url")) : url;
            }
            catch (URISyntaxException e) {
                throw new NamingException("Bad URL: " + environment.get("url"));
            }
            try {
                port = environment.containsKey("port") ? Integer.parseInt((String)environment.get("port")) : port;
            }
            catch (NumberFormatException e) {
                throw new NamingException("Invalid port value" + environment.get("port"));
            }
        }
        if (url == null && (host == null || port == 0)) {
            throw new NamingException("At least URL or host and port attributes must be specified");
        }
        ContentSource contentSource = url != null ? ContentSourceFactory.newContentSource(url) : ContentSourceFactory.newContentSource(host, port, user, password, contentBase);
        contentSource.setAuthenticationPreemptive(authenticationPreemptive);
        return contentSource;
    }
}

