/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.ItemType;
import com.marklogic.xcc.types.impl.AbstractItem;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

abstract class AbstractStringItem
extends AbstractItem {
    protected String value;

    protected AbstractStringItem(ItemType type, String value) {
        super(type);
        this.value = value;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public Reader asReader() {
        return new StringReader(this.asString());
    }

    @Override
    public InputStream asInputStream() {
        try {
            return new ByteArrayInputStream(this.asString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return new ByteArrayInputStream(this.asString().getBytes());
        }
    }

    protected String scrubbedFloatValue(String rawValue) {
        if (rawValue.equalsIgnoreCase("-INF")) {
            return "-Infinity";
        }
        if (rawValue.equalsIgnoreCase("+INF")) {
            return "+Infinity";
        }
        if (rawValue.equalsIgnoreCase("INF")) {
            return "Infinity";
        }
        return rawValue;
    }

    public String toString() {
        return this.asString();
    }
}

