/*
 * Copyright 2003-2018 MarkLogic Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.marklogic.xcc.types.impl;

import com.marklogic.xcc.types.Duration;
import com.marklogic.xcc.types.ItemType;
import com.marklogic.xcc.types.XdmDuration;

abstract public class AbstractDurationItem extends AbstractStringItem {
    private final XdmDuration value;

    public AbstractDurationItem(ItemType type, String value) {
        super(type, value);

        this.value = new Duration(value);
    }

    public XdmDuration asDuration() {
        return value;
    }
}
