/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.schemasloader.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.eval.ServerEvaluationCall;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.JacksonHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.io.File;
import java.io.IOException;
import org.springframework.util.FileCopyUtils;

public class TdeDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor {
    private DatabaseClient databaseClient;
    private String tdeValidationDatabase;

    public TdeDocumentFileProcessor() {
    }

    public TdeDocumentFileProcessor(DatabaseClient databaseClient, String tdeValidationDatabase) {
        this.databaseClient = databaseClient;
        this.tdeValidationDatabase = tdeValidationDatabase;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        boolean isTdeTemplate;
        String uri = documentFile.getUri();
        String extension = documentFile.getFileExtension();
        if (extension != null) {
            extension = extension.toLowerCase();
        }
        boolean bl = isTdeTemplate = "tdej".equals(extension) || "tdex".equals(extension) || uri != null && uri.startsWith("/tde");
        if (isTdeTemplate) {
            documentFile.getDocumentMetadata().withCollections(new String[]{"http://marklogic.com/xdmp/tde"});
        }
        if ("tdej".equals(extension) || "json".equals(extension)) {
            documentFile.setFormat(Format.JSON);
        } else if ("tdex".equals(extension) || "xml".equals(extension)) {
            documentFile.setFormat(Format.XML);
        }
        if (isTdeTemplate) {
            this.validateTdeTemplate(documentFile);
        }
        return documentFile;
    }

    protected void validateTdeTemplate(DocumentFile documentFile) {
        File file = documentFile.getFile();
        if (this.databaseClient == null) {
            this.logger.info("No DatabaseClient provided for TDE validation, so will not validate TDE templates");
        } else if (this.tdeValidationDatabase == null) {
            this.logger.info("No TDE validation database specified, so will not validate TDE templates");
        } else {
            String fileContent = null;
            try {
                fileContent = new String(FileCopyUtils.copyToByteArray((File)file));
            }
            catch (IOException e) {
                this.logger.warn("Could not read TDE template from file, will not validate; cause: " + e.getMessage());
            }
            if (fileContent != null) {
                ServerEvaluationCall call = null;
                if (Format.XML.equals((Object)documentFile.getFormat())) {
                    call = this.buildXqueryCall(documentFile, fileContent);
                } else if (Format.JSON.equals((Object)documentFile.getFormat())) {
                    call = this.buildJavascriptCall(documentFile, fileContent);
                } else {
                    this.logger.info("Unrecognized file format, will not try to validate TDE template in file: " + file + "; format: " + documentFile.getFormat());
                }
                if (call != null) {
                    ObjectNode node = (ObjectNode)((JacksonHandle)call.eval((AbstractReadHandle)new JacksonHandle())).get();
                    if (node.get("valid").asBoolean()) {
                        this.logger.info("TDE template passed validation: " + file);
                    } else {
                        throw new RuntimeException(this.format("TDE template failed validation; file: %s; cause: %s", file, node.get("message").asText()));
                    }
                }
            }
        }
    }

    protected ServerEvaluationCall buildJavascriptCall(DocumentFile documentFile, String fileContent) {
        StringBuilder script = new StringBuilder("var template; xdmp.invokeFunction(function() {var tde = require('/MarkLogic/tde.xqy');");
        script.append(this.format("\nreturn tde.validate([xdmp.toJSON(template)], ['%s'])}, {database: xdmp.database('%s')})", documentFile.getUri(), this.tdeValidationDatabase));
        return this.databaseClient.newServerEval().javascript(script.toString()).addVariable("template", (AbstractWriteHandle)new StringHandle(fileContent).withFormat(Format.JSON));
    }

    protected ServerEvaluationCall buildXqueryCall(DocumentFile documentFile, String fileContent) {
        StringBuilder script = new StringBuilder("import module namespace tde = 'http://marklogic.com/xdmp/tde' at '/MarkLogic/tde.xqy'; ");
        script.append("\ndeclare variable $template external; ");
        script.append("\nxdmp:invoke-function(function() { ");
        script.append(this.format("\ntde:validate($template, '%s')}, <options xmlns='xdmp:eval'><database>{xdmp:database('%s')}</database></options>)", documentFile.getUri(), this.tdeValidationDatabase));
        return this.databaseClient.newServerEval().xquery(script.toString()).addVariable("template", (AbstractWriteHandle)new StringHandle(fileContent).withFormat(Format.XML));
    }

    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    public void setDatabaseClient(DatabaseClient databaseClient) {
        this.databaseClient = databaseClient;
    }

    public String getTdeValidationDatabase() {
        return this.tdeValidationDatabase;
    }

    public void setTdeValidationDatabase(String tdeValidationDatabase) {
        this.tdeValidationDatabase = tdeValidationDatabase;
    }
}

