/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.batch;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.document.DocumentManager;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.document.DocumentWriteSet;
import com.marklogic.client.document.ServerTransform;
import com.marklogic.client.ext.batch.BatchHandler;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.io.Format;
import java.util.List;

public class DefaultBatchHandler
extends LoggingObject
implements BatchHandler {
    private Format contentFormat;
    private ServerTransform serverTransform;

    public DefaultBatchHandler() {
    }

    public DefaultBatchHandler(Format contentFormat, ServerTransform serverTransform) {
        this.contentFormat = contentFormat;
        this.serverTransform = serverTransform;
    }

    @Override
    public void handleBatch(DatabaseClient client, List<? extends DocumentWriteOperation> items) {
        DocumentManager<?, ?> mgr = this.buildDocumentManager(client);
        if (this.contentFormat != null) {
            mgr.setContentFormat(this.contentFormat);
        }
        DocumentWriteSet set = mgr.newWriteSet();
        set.addAll(items);
        int count = set.size();
        String connectionInfo = this.format("port: %d", client.getPort());
        if (client.getDatabase() != null) {
            connectionInfo = connectionInfo + this.format("; database: %s", client.getDatabase());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Writing " + count + " documents to MarkLogic; " + connectionInfo);
        }
        if (this.serverTransform != null) {
            mgr.write(set, this.serverTransform);
        } else {
            mgr.write(set);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Wrote " + count + " documents to MarkLogic; " + connectionInfo);
        }
    }

    protected DocumentManager<?, ?> buildDocumentManager(DatabaseClient client) {
        return client.newDocumentManager();
    }

    public void setServerTransform(ServerTransform serverTransform) {
        this.serverTransform = serverTransform;
    }

    public void setContentFormat(Format contentFormat) {
        this.contentFormat = contentFormat;
    }
}

