/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.PropertiesDrivenDocumentFileProcessor;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import java.util.Properties;

public class PermissionsFileDocumentFileProcessor
extends PropertiesDrivenDocumentFileProcessor {
    private DocumentPermissionsParser documentPermissionsParser;

    public PermissionsFileDocumentFileProcessor() {
        this("permissions.properties");
    }

    public PermissionsFileDocumentFileProcessor(String propertiesFilename) {
        this(propertiesFilename, new DefaultDocumentPermissionsParser());
    }

    public PermissionsFileDocumentFileProcessor(String propertiesFilename, DocumentPermissionsParser documentPermissionsParser) {
        super(propertiesFilename);
        this.documentPermissionsParser = documentPermissionsParser;
    }

    @Override
    protected void processProperties(DocumentFile documentFile, Properties properties) {
        String value;
        String name = documentFile.getFile().getName();
        if (properties.containsKey(name)) {
            value = this.getPropertyValue(properties, name);
            this.documentPermissionsParser.parsePermissions(value, documentFile.getDocumentMetadata().getPermissions());
        }
        if (properties.containsKey("*")) {
            value = this.getPropertyValue(properties, "*");
            this.documentPermissionsParser.parsePermissions(value, documentFile.getDocumentMetadata().getPermissions());
        }
    }

    public void setDocumentPermissionsParser(DocumentPermissionsParser documentPermissionsParser) {
        this.documentPermissionsParser = documentPermissionsParser;
    }
}

