/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.schemasloader.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.batch.RestBatchWriter;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.GenericFileLoader;
import com.marklogic.client.ext.modulesloader.impl.DefaultFileFilter;
import com.marklogic.client.ext.schemasloader.SchemasLoader;
import com.marklogic.client.ext.schemasloader.impl.TdeDocumentFileProcessor;
import com.marklogic.client.ext.schemasloader.impl.TdeUtil;
import com.marklogic.client.io.DocumentMetadataHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class DefaultSchemasLoader
extends GenericFileLoader
implements SchemasLoader {
    private DatabaseClient schemasDatabaseClient;
    private String tdeValidationDatabase;

    public DefaultSchemasLoader(DatabaseClient schemasDatabaseClient) {
        this(schemasDatabaseClient, null);
    }

    public DefaultSchemasLoader(DatabaseClient schemasDatabaseClient, String tdeValidationDatabase) {
        super(((Supplier<BatchWriter>)() -> {
            RestBatchWriter writer = new RestBatchWriter(schemasDatabaseClient);
            writer.setThreadCount(1);
            writer.setReleaseDatabaseClients(false);
            return writer;
        }).get());
        this.schemasDatabaseClient = schemasDatabaseClient;
        this.tdeValidationDatabase = tdeValidationDatabase;
        this.initializeDefaultSchemasLoader();
    }

    public DefaultSchemasLoader(BatchWriter batchWriter) {
        super(batchWriter);
        this.initializeDefaultSchemasLoader();
    }

    protected void initializeDefaultSchemasLoader() {
        this.addDocumentFileProcessor(new TdeDocumentFileProcessor(this.schemasDatabaseClient, this.tdeValidationDatabase));
        this.addFileFilter(new DefaultFileFilter());
    }

    @Override
    public List<DocumentFile> loadSchemas(String ... paths) {
        if (TdeUtil.templateBatchInsertSupported(this.schemasDatabaseClient) && StringUtils.hasText((String)this.tdeValidationDatabase)) {
            List<DocumentFile> documentFiles = super.getDocumentFiles(paths);
            ArrayList<DocumentFile> tdeFiles = new ArrayList<DocumentFile>();
            ArrayList<DocumentFile> nonTdeFiles = new ArrayList<DocumentFile>();
            for (DocumentFile file : documentFiles) {
                DocumentMetadataHandle metadata = file.getMetadata();
                if (metadata != null && metadata.getCollections().contains((Object)"http://marklogic.com/xdmp/tde")) {
                    tdeFiles.add(file);
                    continue;
                }
                nonTdeFiles.add(file);
            }
            if (!tdeFiles.isEmpty()) {
                this.loadTdeTemplatesViaBatchInsert(tdeFiles);
            }
            if (!nonTdeFiles.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Non-TDE files: " + nonTdeFiles);
                }
                super.writeDocumentFiles(nonTdeFiles);
            }
            return documentFiles;
        }
        return super.loadFiles(paths);
    }

    public String getTdeValidationDatabase() {
        return this.tdeValidationDatabase;
    }

    public void setTdeValidationDatabase(String tdeValidationDatabase) {
        this.tdeValidationDatabase = tdeValidationDatabase;
    }

    private void loadTdeTemplatesViaBatchInsert(List<DocumentFile> tdeFiles) {
        this.logger.info("Loading and validating TDE templates via tde.templateBatchInsert; templates: " + tdeFiles.stream().map(documentFile -> documentFile.getFile().getName()).collect(Collectors.toList()));
        String query = this.buildTdeBatchInsertQuery(tdeFiles);
        StringBuilder script = new StringBuilder("declareUpdate(); xdmp.invokeFunction(function() {var tde = require('/MarkLogic/tde.xqy');");
        script.append(query);
        script.append(this.format("}, {database: xdmp.database('%s')})", this.tdeValidationDatabase));
        try {
            this.schemasDatabaseClient.newServerEval().javascript(script.toString()).eval().close();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to load and validate TDE templates via tde.templateBatchInsert; cause: " + ex.getMessage() + "; the following script can be run in Query Console against your content database to see the TDE validation error:\n" + script, ex);
        }
    }

    private String buildTdeBatchInsertQuery(List<DocumentFile> documentFiles) {
        ArrayList<String> templateInfoList = new ArrayList<String>();
        for (DocumentFile doc : documentFiles) {
            String uri = doc.getUri();
            String content = doc.getContent().toString();
            DocumentMetadataHandle.DocumentPermissions documentPermissions = doc.getDocumentMetadata().getPermissions();
            ArrayList permissionList = new ArrayList();
            documentPermissions.keySet().forEach(key -> {
                Set values = (Set)documentPermissions.get(key);
                values.forEach(value -> permissionList.add(String.format("xdmp.permission('%s', '%s')", key, value)));
            });
            String permissions = "[".concat(permissionList.stream().map(String::toLowerCase).collect(Collectors.joining(", "))).concat("]");
            ArrayList collectionsList = new ArrayList();
            doc.getDocumentMetadata().getCollections().forEach(collection -> collectionsList.add(collection));
            String collections = collectionsList.stream().map(coll -> '\"' + coll + '\"').collect(Collectors.joining(", "));
            collections = "[".concat(collections).concat("]");
            String templateFormat = "";
            templateFormat = doc.getFormat().toString().equals("XML") ? String.format("tde.templateInfo('%s', xdmp.unquote(`%s`), %s, %s)", uri, content, permissions, collections) : (doc.getFormat().toString().equals("JSON") ? String.format("tde.templateInfo('%s', xdmp.toJSON(%s), %s, %s)", uri, content, permissions, collections) : String.format("tde.templateInfo('%s',%s, %s, %s)", uri, content, permissions, collections));
            templateInfoList.add(templateFormat);
        }
        String templateString = "tde.templateBatchInsert([".concat(templateInfoList.stream().collect(Collectors.joining(","))).concat("]);");
        return templateString;
    }
}

