/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.AbstractDocumentFileReader;
import com.marklogic.client.ext.file.CollectionsFileDocumentFileProcessor;
import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileReader;
import com.marklogic.client.ext.file.PermissionsFileDocumentFileProcessor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;

public class DefaultDocumentFileReader
extends AbstractDocumentFileReader
implements FileVisitor<Path>,
DocumentFileReader {
    private Path currentRootPath;
    private List<FileFilter> fileFilters;
    private List<DocumentFile> documentFiles;
    private String uriPrefix = "/";
    private CollectionsFileDocumentFileProcessor collectionsFileDocumentFileProcessor;
    private PermissionsFileDocumentFileProcessor permissionsFileDocumentFileProcessor;

    public DefaultDocumentFileReader() {
        this.initialize();
    }

    @Override
    public List<DocumentFile> readDocumentFiles(String ... paths) {
        this.documentFiles = new ArrayList<DocumentFile>();
        for (String path : paths) {
            Path p;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.format("Finding files at path: %s", path));
            }
            if ((p = this.constructPath(path)) != null) {
                this.currentRootPath = p;
                try {
                    Files.walkFileTree(this.currentRootPath, this);
                    continue;
                }
                catch (IOException ie) {
                    throw new RuntimeException(this.format("IO error while walking file tree at path: %s", path), ie);
                }
            }
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Path does not exist, so not reading files from it: " + path);
        }
        return this.documentFiles;
    }

    protected Path constructPath(String path) {
        File f;
        if (path.startsWith("classpath") || path.startsWith("file:")) {
            try {
                f = new File(new URI(path));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            f = new File(path);
        }
        return f.exists() ? Paths.get(f.getAbsolutePath(), new String[0]) : null;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        boolean accept = this.acceptPath(dir, attrs);
        if (accept) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Visiting directory: " + dir);
            }
            return FileVisitResult.CONTINUE;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Skipping directory: " + dir);
        }
        return FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc != null) {
            this.logger.warn("Failed visiting file: " + exc.getMessage(), (Throwable)exc);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc != null) {
            this.logger.warn("Error in postVisitDirectory: " + exc.getMessage(), (Throwable)exc);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (this.acceptPath(path, attrs)) {
            DocumentFile documentFile = this.buildDocumentFile(path, this.currentRootPath);
            if ((documentFile = this.processDocumentFile(documentFile)) != null) {
                this.documentFiles.add(documentFile);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    protected boolean acceptPath(Path path, BasicFileAttributes attrs) {
        if (this.fileFilters != null) {
            File file = path.toFile();
            for (FileFilter filter : this.fileFilters) {
                if (filter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    protected DocumentFile buildDocumentFile(Path path, Path currentRootPath) {
        Path relPath = currentRootPath.relativize(path);
        String uri = relPath.toString().replace("\\", "/");
        if (this.uriPrefix != null) {
            uri = this.uriPrefix + uri;
        }
        File f = path.toFile();
        DocumentFile df = new DocumentFile(uri, f);
        df.setRootPath(currentRootPath);
        return df;
    }

    protected void initialize() {
        this.collectionsFileDocumentFileProcessor = new CollectionsFileDocumentFileProcessor();
        this.permissionsFileDocumentFileProcessor = new PermissionsFileDocumentFileProcessor();
        this.addFileFilter(this.collectionsFileDocumentFileProcessor);
        this.addFileFilter(this.permissionsFileDocumentFileProcessor);
        this.addDocumentFileProcessor(this.collectionsFileDocumentFileProcessor);
        this.addDocumentFileProcessor(this.permissionsFileDocumentFileProcessor);
        this.addDocumentFileProcessor(this.getFormatDocumentFileProcessor());
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (this.fileFilters == null) {
            this.fileFilters = new ArrayList<FileFilter>();
        }
        this.fileFilters.add(fileFilter);
    }

    public List<FileFilter> getFileFilters() {
        return this.fileFilters;
    }

    public void setFileFilters(List<FileFilter> fileFilters) {
        this.fileFilters = fileFilters;
    }

    public void setUriPrefix(String uriPrefix) {
        this.uriPrefix = uriPrefix;
    }

    public CollectionsFileDocumentFileProcessor getCollectionsFileDocumentFileProcessor() {
        return this.collectionsFileDocumentFileProcessor;
    }

    public PermissionsFileDocumentFileProcessor getPermissionsFileDocumentFileProcessor() {
        return this.permissionsFileDocumentFileProcessor;
    }
}

