/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.spring;

import com.marklogic.client.ext.DatabaseClientConfig;
import com.marklogic.client.ext.helper.DatabaseClientProvider;
import com.marklogic.client.ext.spring.SimpleDatabaseClientProvider;
import com.marklogic.xcc.template.XccTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@PropertySource(value={"file:gradle.properties"}, ignoreResourceNotFound=true)
public class BasicConfig {
    @Value(value="${mlAppName}")
    private String mlAppName;
    @Value(value="${mlUsername:admin}")
    private String mlUsername;
    @Value(value="${mlPassword}")
    private String mlPassword;
    @Value(value="${mlHost:localhost}")
    private String mlHost;
    @Value(value="${mlRestPort:0}")
    private Integer mlRestPort;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertyConfigurer() {
        PropertySourcesPlaceholderConfigurer c = new PropertySourcesPlaceholderConfigurer();
        c.setIgnoreResourceNotFound(true);
        return c;
    }

    @Bean
    public DatabaseClientConfig databaseClientConfig() {
        return new DatabaseClientConfig(this.getMlHost(), this.getRestPort(), this.getMlUsername(), this.getMlPassword());
    }

    @Bean
    public XccTemplate xccTemplate() {
        return new XccTemplate(this.getMlHost(), 8000, this.getMlUsername(), this.getMlPassword(), this.buildContentDatabaseName(this.mlAppName));
    }

    protected String buildContentDatabaseName(String mlAppName) {
        return mlAppName + "-content";
    }

    @Bean
    public DatabaseClientProvider databaseClientProvider() {
        return new SimpleDatabaseClientProvider(this.databaseClientConfig());
    }

    protected Integer getRestPort() {
        return this.mlRestPort;
    }

    public String getMlUsername() {
        return this.mlUsername;
    }

    public String getMlPassword() {
        return this.mlPassword;
    }

    public String getMlHost() {
        return this.mlHost;
    }

    public Integer getMlRestPort() {
        return this.mlRestPort;
    }

    public String getMlAppName() {
        return this.mlAppName;
    }

    public void setMlAppName(String mlAppName) {
        this.mlAppName = mlAppName;
    }
}

