/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.util.DefaultDocumentPermissionsParser;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;

public class PermissionsDocumentFileProcessor
implements DocumentFileProcessor {
    private String permissions;
    private DocumentPermissionsParser documentPermissionsParser;

    public PermissionsDocumentFileProcessor(String permissions) {
        this(permissions, new DefaultDocumentPermissionsParser());
    }

    public PermissionsDocumentFileProcessor(String permissions, DocumentPermissionsParser documentPermissionsParser) {
        this.permissions = permissions;
        this.documentPermissionsParser = documentPermissionsParser;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        DocumentMetadataHandle metadata;
        if (this.permissions != null && this.documentPermissionsParser != null && (metadata = documentFile.getDocumentMetadata()) != null) {
            this.documentPermissionsParser.parsePermissions(this.permissions, metadata.getPermissions());
        }
        return documentFile;
    }
}

