/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.ssl;

import com.marklogic.client.ext.ssl.SslConfig;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class SslUtil {
    public static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";

    public static SslConfig configureUsingTrustManagerFactory() {
        return SslUtil.configureUsingTrustManagerFactory(DEFAULT_SSL_PROTOCOL, null);
    }

    public static SslConfig configureUsingTrustManagerFactory(String protocol, String algorithm) {
        TrustManagerFactory trustManagerFactory;
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to instantiate SSLContext with protocol: " + protocol + "; cause: " + e.getMessage(), e);
        }
        if (algorithm == null || algorithm.trim().length() < 1) {
            algorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to instantiate TrustManagerFactory, cause: " + e.getMessage(), e);
        }
        try {
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Unable to initialize TrustManagerFactory, cause: " + e.getMessage(), e);
        }
        X509TrustManager x509TrustManager = null;
        for (TrustManager tm : trustManagerFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            x509TrustManager = (X509TrustManager)tm;
            break;
        }
        if (x509TrustManager == null) {
            throw new RuntimeException("Could not initialize an SSLContext; unable to find an X509TrustManager in the TrustManagerFactory instantiated with algorithm: " + algorithm);
        }
        try {
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Unable to initialize SSLContext, cause: " + e.getMessage(), e);
        }
        return new SslConfig(sslContext, x509TrustManager);
    }
}

