/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.xcc;

import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.ext.xcc.DocumentWriteOperationAdapter;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.DocumentMetadataHandle;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.DocumentMetadataWriteHandle;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.DocumentFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DefaultDocumentWriteOperationAdapter
implements DocumentWriteOperationAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDocumentWriteOperationAdapter.class);

    @Override
    public Content adapt(DocumentWriteOperation operation) {
        String uri = operation.getUri();
        ContentCreateOptions options = this.adaptMetadata(operation.getMetadata());
        AbstractWriteHandle handle = operation.getContent();
        if (handle instanceof StringHandle) {
            return ContentFactory.newContent((String)uri, (String)((StringHandle)handle).get(), (ContentCreateOptions)options);
        }
        if (handle instanceof FileHandle) {
            return ContentFactory.newContent((String)uri, (File)((FileHandle)handle).get(), (ContentCreateOptions)options);
        }
        if (handle instanceof BytesHandle) {
            return ContentFactory.newContent((String)uri, (byte[])((BytesHandle)handle).get(), (ContentCreateOptions)options);
        }
        if (handle instanceof InputStreamHandle) {
            try {
                return ContentFactory.newContent((String)uri, (InputStream)((InputStreamHandle)handle).get(), (ContentCreateOptions)options);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read content input stream: " + e.getMessage(), e);
            }
        }
        if (handle instanceof DOMHandle) {
            return ContentFactory.newContent((String)uri, (Document)((DOMHandle)handle).get(), (ContentCreateOptions)options);
        }
        throw new IllegalArgumentException("No support yet for content class: " + handle.getClass().getName());
    }

    protected ContentCreateOptions adaptMetadata(DocumentMetadataWriteHandle handle) {
        ContentCreateOptions options = new ContentCreateOptions();
        if (handle instanceof DocumentMetadataHandle) {
            DocumentMetadataHandle metadata = (DocumentMetadataHandle)handle;
            options.setQuality(metadata.getQuality());
            options.setCollections((String[])metadata.getCollections().toArray((Object[])new String[0]));
            this.adaptPermissions(options, metadata);
            this.adaptFormat(options, metadata);
        } else {
            logger.warn("Only supports DocumentMetadataHandle; unsupported metadata class: " + handle.getClass().getName());
        }
        return options;
    }

    protected void adaptFormat(ContentCreateOptions options, DocumentMetadataHandle metadata) {
        Format format = metadata.getFormat();
        DocumentFormat xccFormat = null;
        if (format != null) {
            if (Format.BINARY.equals((Object)format)) {
                xccFormat = DocumentFormat.BINARY;
            } else if (Format.JSON.equals((Object)format)) {
                xccFormat = DocumentFormat.JSON;
            } else if (Format.TEXT.equals((Object)format)) {
                xccFormat = DocumentFormat.TEXT;
            } else if (Format.XML.equals((Object)format)) {
                xccFormat = DocumentFormat.XML;
            } else if (Format.UNKNOWN.equals((Object)format)) {
                xccFormat = DocumentFormat.NONE;
            } else if (logger.isDebugEnabled()) {
                logger.debug("Unsupported format, can't adapt to an XCC DocumentFormat; " + format.toString());
            }
        }
        if (xccFormat != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adapted REST format " + format + " to XCC format: " + xccFormat.toString());
            }
            options.setFormat(xccFormat);
        }
    }

    protected void adaptPermissions(ContentCreateOptions options, DocumentMetadataHandle metadata) {
        HashSet<ContentPermission> contentPermissions = new HashSet<ContentPermission>();
        DocumentMetadataHandle.DocumentPermissions permissions = metadata.getPermissions();
        for (String role : permissions.keySet()) {
            for (DocumentMetadataHandle.Capability capability : (Set)permissions.get((Object)role)) {
                ContentCapability contentCapability;
                if (DocumentMetadataHandle.Capability.EXECUTE.equals((Object)capability)) {
                    contentCapability = ContentCapability.EXECUTE;
                } else if (DocumentMetadataHandle.Capability.INSERT.equals((Object)capability)) {
                    contentCapability = ContentCapability.INSERT;
                } else if (DocumentMetadataHandle.Capability.READ.equals((Object)capability)) {
                    contentCapability = ContentCapability.READ;
                } else if (DocumentMetadataHandle.Capability.UPDATE.equals((Object)capability)) {
                    contentCapability = ContentCapability.UPDATE;
                } else {
                    throw new IllegalArgumentException("Unrecognized permission capability: " + capability);
                }
                contentPermissions.add(new ContentPermission(contentCapability, role));
            }
        }
        options.setPermissions(contentPermissions.toArray(new ContentPermission[0]));
    }
}

