/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.util.DocumentPermissionsParser;
import com.marklogic.client.io.DocumentMetadataHandle;

public class PermissionsDocumentFileProcessor
implements DocumentFileProcessor {
    private String commaDelimitedRolesAndCapabilities;
    private DocumentPermissionsParser documentPermissionsParser;

    public PermissionsDocumentFileProcessor(String commaDelimitedRolesAndCapabilities) {
        this.commaDelimitedRolesAndCapabilities = commaDelimitedRolesAndCapabilities;
    }

    public PermissionsDocumentFileProcessor(String commaDelimitedRolesAndCapabilities, DocumentPermissionsParser documentPermissionsParser) {
        this.commaDelimitedRolesAndCapabilities = commaDelimitedRolesAndCapabilities;
        this.documentPermissionsParser = documentPermissionsParser;
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        DocumentMetadataHandle metadata;
        if (this.commaDelimitedRolesAndCapabilities != null && (metadata = documentFile.getDocumentMetadata()) != null) {
            if (this.documentPermissionsParser != null) {
                this.documentPermissionsParser.parsePermissions(this.commaDelimitedRolesAndCapabilities, metadata.getPermissions());
            } else {
                metadata.getPermissions().addFromDelimitedString(this.commaDelimitedRolesAndCapabilities);
            }
        }
        return documentFile;
    }
}

