/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.modulesloader.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.batch.BatchWriter;
import com.marklogic.client.ext.file.GenericFileLoader;
import com.marklogic.client.ext.modulesloader.ModulesManager;
import com.marklogic.client.ext.modulesloader.impl.DefaultFileFilter;
import com.marklogic.client.ext.modulesloader.impl.ExtDocumentFileProcessor;
import com.marklogic.client.ext.modulesloader.impl.ModulesManagerDocumentFileProcessor;

public class AssetFileLoader
extends GenericFileLoader {
    public static final String DEFAULT_PERMISSIONS = "rest-admin,read,rest-admin,update,rest-extension-user,execute";

    public AssetFileLoader(DatabaseClient modulesDatabaseClient) {
        this(modulesDatabaseClient, null);
    }

    public AssetFileLoader(DatabaseClient modulesDatabaseClient, ModulesManager modulesManager) {
        super(modulesDatabaseClient);
        this.initializeAssetFileLoader(modulesManager);
    }

    public AssetFileLoader(BatchWriter batchWriter) {
        this(batchWriter, null);
    }

    public AssetFileLoader(BatchWriter batchWriter, ModulesManager modulesManager) {
        super(batchWriter);
        this.initializeAssetFileLoader(modulesManager);
    }

    protected void initializeAssetFileLoader(ModulesManager modulesManager) {
        this.addFileFilter(new DefaultFileFilter());
        this.addDocumentFileProcessor(new ExtDocumentFileProcessor());
        if (modulesManager != null) {
            this.addDocumentFileProcessor(new ModulesManagerDocumentFileProcessor(modulesManager));
        }
        this.setPermissions(DEFAULT_PERMISSIONS);
    }
}

