/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import com.marklogic.ps.Session;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.exceptions.UnimplementedFeatureException;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.exceptions.XccException;
import com.marklogic.xcc.spi.ConnectionProvider;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Connection
implements ContentSource {
    protected URI[] uri;
    protected ContentSource[] cs;
    protected volatile int count = 0;
    private final Object securityOptionsMutex = new Object();
    protected static SecurityOptions securityOptions = null;

    public Connection(URI uri) throws XccException, KeyManagementException, NoSuchAlgorithmException {
        this.init(new URI[]{uri});
    }

    public Connection(URI[] uris) throws XccException, KeyManagementException, NoSuchAlgorithmException {
        this.init(uris);
    }

    private void init(URI[] uris) throws XccConfigException, KeyManagementException, NoSuchAlgorithmException {
        if (null == uris || 1 > uris.length) {
            throw new NullPointerException("must supply uris");
        }
        this.uri = new URI[uris.length];
        this.cs = new ContentSource[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            if (null == uris[i].getHost()) {
                throw new UnimplementedFeatureException("bad URI: cannot parse host from " + uris[i]);
            }
            this.uri[i] = uris[i];
            boolean ssl = this.uri[i].getScheme().equals("xccs");
            this.cs[i] = ssl ? ContentSourceFactory.newContentSource((URI)this.uri[i], (SecurityOptions)this.getSecurityOptions()) : ContentSourceFactory.newContentSource((URI)this.uri[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityOptions getSecurityOptions() throws KeyManagementException, NoSuchAlgorithmException {
        if (null != securityOptions) {
            return securityOptions;
        }
        Object object = this.securityOptionsMutex;
        synchronized (object) {
            if (null != securityOptions) {
                return securityOptions;
            }
            securityOptions = Connection.newTrustAnyoneOptions();
            return securityOptions;
        }
    }

    public URI getUri() {
        return this.uri[this.count++ % this.uri.length];
    }

    public com.marklogic.xcc.Session newSession() {
        return new Session(this, this.getContentSource().newSession());
    }

    public boolean isAuthenticationPreemptive() {
        return this.getContentSource().isAuthenticationPreemptive();
    }

    public void setAuthenticationPreemptive(boolean value) {
        this.getContentSource().setAuthenticationPreemptive(value);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.getContentSource().getConnectionProvider();
    }

    public synchronized ContentSource getContentSource() {
        return this.cs[this.count++ % this.cs.length];
    }

    public com.marklogic.xcc.Session newSession(String userName, char[] password) {
        return new Session(this, this.getContentSource().newSession(userName, password));
    }

    public com.marklogic.xcc.Session newSession(String userName, char[] password, String contentbaseId) {
        return new Session(this, this.getContentSource().newSession(userName, password, contentbaseId));
    }

    public com.marklogic.xcc.Session newSession(String contentbaseId) {
        return new Session(this, this.getContentSource().newSession(contentbaseId));
    }

    @Deprecated
    public com.marklogic.xcc.Session newSession(String userName, String password) {
        return new Session(this, this.getContentSource().newSession(userName, password.toCharArray()));
    }

    @Deprecated
    public com.marklogic.xcc.Session newSession(String userName, String password, String contentbaseId) {
        return this.newSession(userName, password.toCharArray(), contentbaseId);
    }

    public Logger getDefaultLogger() {
        return this.getContentSource().getDefaultLogger();
    }

    public void setDefaultLogger(Logger logger) {
        this.getContentSource().setDefaultLogger(logger);
    }

    protected static SecurityOptions newTrustAnyoneOptions() throws KeyManagementException, NoSuchAlgorithmException {
        TrustManager[] trust = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, trust, null);
        return new SecurityOptions(sslContext);
    }
}

