/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileFinder {
    private String startPath = "";
    private FileFilter filter;
    private final List<File> list = new ArrayList<File>();
    private String includePattern;
    private String excludePattern;

    public FileFinder(String path) {
        if (path == null) {
            throw new NullPointerException("starting path cannot be null");
        }
        this.startPath = path;
    }

    public FileFinder(String path, String pattern) {
        if (path == null) {
            throw new NullPointerException("starting path cannot be null");
        }
        this.startPath = path;
        this.includePattern = pattern;
    }

    public FileFinder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("starting path cannot be null");
        }
        this.startPath = file.getCanonicalPath();
    }

    public FileFinder(File file, String pattern) throws IOException {
        if (file == null) {
            throw new NullPointerException("starting path cannot be null");
        }
        this.startPath = file.getCanonicalPath();
        this.includePattern = pattern;
    }

    public FileFinder(File file, String includePattern, String excludePattern) throws IOException {
        if (file == null) {
            throw new NullPointerException("starting path cannot be null");
        }
        this.startPath = file.getCanonicalPath();
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
    }

    public FileFinder(String path, String includePattern, String excludePattern) {
        if (path == null) {
            throw new NullPointerException("starting path cannot be null");
        }
        this.startPath = path;
        this.includePattern = includePattern;
        this.excludePattern = excludePattern;
    }

    public static void main(String[] args) throws IOException {
        File theFile;
        System.out.println("Finding all files in /tmp");
        FileFinder ff = new FileFinder("/tmp");
        ff.find();
        while (ff.size() > 0) {
            theFile = ff.remove();
            System.out.println("found file: " + theFile.getCanonicalPath());
        }
        System.out.println("Finding all exe files in /tmp");
        ff = new FileFinder("/tmp", ".+\\.exe$");
        ff.find();
        while (ff.size() > 0) {
            theFile = ff.remove();
            System.out.println("found file: " + theFile.getCanonicalPath());
        }
    }

    public void find() throws IOException {
        File[] dirList;
        if (this.filter == null) {
            this.filter = this.includePattern == null && this.excludePattern == null ? file -> file.isDirectory() || file.isFile() : (this.excludePattern == null ? file -> file.isDirectory() || file.isFile() && file.getName().matches(this.includePattern) : (this.includePattern == null ? file -> file.isDirectory() || file.isFile() && !file.getName().matches(this.excludePattern) : file -> file.isDirectory() || file.isFile() && file.getName().matches(this.includePattern) && !file.getName().matches(this.excludePattern)));
        }
        if (this.startPath == null) {
            this.startPath = "";
        }
        if ((dirList = new File(this.startPath).listFiles(this.filter)) == null) {
            return;
        }
        for (File file2 : dirList) {
            if (file2.isFile()) {
                this.list.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            this.startPath = file2.getCanonicalPath();
            this.find();
        }
    }

    public File remove() {
        return this.list.remove(0);
    }

    public int size() {
        if (this.list == null) {
            throw new NullPointerException("FileFinder has not been initialized");
        }
        return this.list.size();
    }

    public List<File> list() {
        return this.list;
    }

    public List<String> listCanonicalPaths() throws IOException {
        int size = this.list.size();
        ArrayList<String> paths = new ArrayList<String>(size);
        for (File f : this.list) {
            paths.add(f.getCanonicalPath());
        }
        return paths;
    }

    public List<String> listRelativePaths(String root) {
        int rootLength = root.length();
        int size = this.list.size();
        ArrayList<String> paths = new ArrayList<String>(size);
        for (File f : this.list) {
            paths.add(f.getAbsolutePath().substring(rootLength));
        }
        return paths;
    }

    public void add(File file) {
        this.list.add(file);
    }
}

