/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class OneLineFormatter
extends Formatter {
    private final Date dat = new Date();
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final FieldPosition pos = new FieldPosition(0);
    private final String lineSeparator = System.getProperty("line.separator");

    @Override
    public synchronized String format(LogRecord logRecord) {
        StringBuffer sb = new StringBuffer();
        this.dat.setTime(logRecord.getMillis());
        this.formatter.format(this.dat, sb, this.pos);
        sb.append(" ");
        String message = this.formatMessage(logRecord);
        sb.append(logRecord.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (logRecord.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                logRecord.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

