/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import com.marklogic.ps.PropertyClientInterface;
import com.marklogic.ps.SimpleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

public class PropertyManager
extends Thread {
    protected static final SimpleLogger logger = SimpleLogger.getSimpleLogger();
    protected File propertyFile;
    protected long lastModified;
    private static final long SLEEP_TIME = 500L;
    private final Properties properties;
    protected final String propertyFilePath;
    protected PropertyClientInterface[] clients;

    public PropertyManager(String propertyFilePath) {
        this.propertyFilePath = propertyFilePath;
        this.propertyFile = new File(propertyFilePath);
        this.lastModified = this.propertyFile.lastModified();
        this.properties = new Properties();
    }

    protected void reload() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(this.propertyFilePath);){
            this.properties.load(fileInputStream);
        }
        logger.configureLogger(this.properties);
    }

    @Override
    public void run() {
        while (this.propertyFile != null && this.propertyFile.exists() && this.propertyFile.canRead()) {
            long newLastModified = this.propertyFile.lastModified();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("checking properties: " + newLastModified + " > " + this.lastModified);
            }
            if (newLastModified > this.lastModified) {
                logger.info("updating properties");
                try {
                    this.reload();
                    if (this.clients != null) {
                        for (PropertyClientInterface client : this.clients) {
                            if (client == null) continue;
                            client.setProperties(this.properties);
                        }
                    }
                }
                catch (IOException e) {
                    logger.logException(this.propertyFilePath, e);
                }
                this.lastModified = newLastModified;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void addClients(PropertyClientInterface[] clients) {
        this.clients = clients;
    }

    public void add(PropertyClientInterface client) {
        if (this.clients == null) {
            this.clients = new PropertyClientInterface[]{client};
        } else {
            PropertyClientInterface[] newClients = new PropertyClientInterface[1 + this.clients.length];
            System.arraycopy(this.clients, 0, newClients, 0, this.clients.length);
            newClients[this.clients.length] = client;
            this.clients = newClients;
        }
    }

    public void quit() {
        this.propertyFile = null;
        try {
            this.notify();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }
}

