/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import com.marklogic.ps.Connection;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentbaseMetaData;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccException;
import com.marklogic.xcc.types.XSBoolean;
import com.marklogic.xcc.types.XSInteger;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class Session
implements com.marklogic.xcc.Session {
    public static final String XQUERY_VERSION_1_0_ML = "xquery version \"1.0-ml\";\n";
    private final com.marklogic.xcc.Session session;
    private final Connection conn;

    public Session(Connection conn, com.marklogic.xcc.Session session) {
        this.conn = conn;
        this.session = session;
    }

    public Connection getContentSource() {
        return this.conn;
    }

    public UserCredentials getUserCredentials() {
        return this.session.getUserCredentials();
    }

    public String getContentBaseName() {
        return this.session.getContentBaseName();
    }

    public boolean commit() throws RequestException {
        return this.session.commit();
    }

    public void rollback() throws RequestException {
        this.session.rollback();
    }

    public void close() {
        this.session.close();
    }

    public boolean isAutoCommit() {
        return this.session.isAutoCommit();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public ResultSequence submitRequest(Request request) throws RequestException {
        return this.session.submitRequest(request);
    }

    public AdhocQuery newAdhocQuery(String queryText, RequestOptions options) {
        return this.session.newAdhocQuery(queryText, options);
    }

    public AdhocQuery newAdhocQuery(String queryText) {
        return this.session.newAdhocQuery(queryText);
    }

    public ModuleInvoke newModuleInvoke(String moduleUri, RequestOptions options) {
        return this.session.newModuleInvoke(moduleUri, options);
    }

    public ModuleInvoke newModuleInvoke(String moduleUri) {
        return this.session.newModuleInvoke(moduleUri);
    }

    public ModuleSpawn newModuleSpawn(String moduleUri, RequestOptions options) {
        return this.session.newModuleSpawn(moduleUri, options);
    }

    public ModuleSpawn newModuleSpawn(String moduleUri) {
        return this.session.newModuleSpawn(moduleUri);
    }

    public void insertContent(Content content) throws RequestException {
        this.session.insertContent(content);
    }

    public void insertContent(Content[] content) throws RequestException {
        this.session.insertContent(content);
    }

    public List<RequestException> insertContentCollectErrors(Content[] content) {
        return new ArrayList<RequestException>(0);
    }

    public ContentbaseMetaData getContentbaseMetaData() {
        return this.session.getContentbaseMetaData();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.session.setAutoCommit(autoCommit);
    }

    public void setDefaultRequestOptions(RequestOptions options) {
        this.session.setDefaultRequestOptions(options);
    }

    public RequestOptions getDefaultRequestOptions() {
        return this.session.getDefaultRequestOptions();
    }

    public void setUpdate(Session.Update update) {
        this.session.setUpdate(update);
    }

    public Session.Update getUpdate() {
        return this.session.getUpdate();
    }

    public RequestOptions getEffectiveRequestOptions() {
        return this.session.getEffectiveRequestOptions();
    }

    public BigInteger getCurrentServerPointInTime() throws RequestException {
        return this.session.getCurrentServerPointInTime();
    }

    public Logger getLogger() {
        return this.session.getLogger();
    }

    public void setLogger(Logger logger) {
        this.session.setLogger(logger);
    }

    public void setUserObject(Object userObject) {
        this.session.setUserObject(userObject);
    }

    public Object getUserObject() {
        return this.session.getUserObject();
    }

    public boolean existsDocument(String uri) throws XccException {
        String query = "xquery version \"1.0-ml\";\ndeclare variable $URI as xs:string external;\nboolean(doc($URI))\n";
        AdhocQuery req = this.session.newAdhocQuery(query);
        req.setNewStringVariable("URI", uri);
        ResultSequence result = this.session.submitRequest((Request)req);
        return ((XSBoolean)result.next().getItem()).asPrimitiveBoolean();
    }

    public long getCount() throws XccException {
        String query = "xquery version \"1.0-ml\";\nxdmp:estimate(doc())";
        AdhocQuery req = this.session.newAdhocQuery(query);
        ResultSequence result = this.session.submitRequest((Request)req);
        return ((XSInteger)result.next().getItem()).asPrimitiveLong();
    }

    public void deleteDocument(String uri) throws XccException {
        String query = "xquery version \"1.0-ml\";\ndeclare variable $URI as xs:string external;\nif (boolean(doc($URI)))\nthen xdmp:document-delete($URI) else ()\n";
        AdhocQuery req = this.session.newAdhocQuery(query);
        req.setNewStringVariable("URI", uri);
        this.session.submitRequest((Request)req);
    }

    public void deleteCollection(String uri) throws XccException {
        String query = "xquery version \"1.0-ml\";\ndeclare variable $URI as xs:string external;\nxdmp:collection-delete($URI)\n";
        AdhocQuery req = this.session.newAdhocQuery(query);
        req.setNewStringVariable("URI", uri);
        this.session.submitRequest((Request)req);
    }

    public void setDocumentProperties(String uri, String xmlString) throws XccException {
        String query = "xquery version \"1.0-ml\";\ndeclare variable $URI as xs:string external;\ndeclare variable $XML-STRING as xs:string external;\nxdmp:document-set-properties($URI,\n  xdmp:unquote($XML-STRING)/prop:properties/node() )\n";
        AdhocQuery req = this.session.newAdhocQuery(query);
        req.setNewStringVariable("URI", uri);
        req.setNewStringVariable("XML-STRING", xmlString);
        this.session.submitRequest((Request)req);
    }

    public Map<String, BigInteger> getForestMap() throws XccException {
        return this.session.getContentbaseMetaData().getForestMap();
    }

    public BigInteger[] forestNamesToIds(String[] names) throws XccException {
        if (names == null) {
            return new BigInteger[0];
        }
        Map map = this.session.getContentbaseMetaData().getForestMap();
        ArrayList list = new ArrayList();
        for (String name : names) {
            list.add(map.get(name));
        }
        return list.toArray(new BigInteger[0]);
    }

    public URI getConnectionUri() {
        return this.session.getConnectionUri();
    }

    @Deprecated
    public void setTransactionMode(Session.TransactionMode mode) {
        this.session.setTransactionMode(mode);
    }

    @Deprecated
    public Session.TransactionMode getTransactionMode() {
        return this.session.getTransactionMode();
    }

    public void setTransactionTimeout(int seconds) throws RequestException {
        this.session.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws RequestException {
        return this.session.getTransactionTimeout();
    }

    public XAResource getXAResource() {
        return this.session.getXAResource();
    }

    public int getCachedTxnTimeout() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

