/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import com.marklogic.ps.OneLineFormatter;
import com.marklogic.ps.PropertyClientInterface;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class SimpleLogger
extends Logger
implements PropertyClientInterface {
    public static final String LOG_FILEHANDLER_LIMIT = "LOG_FILEHANDLER_LIMIT";
    public static final String LOG_FILEHANDLER_COUNT = "LOG_FILEHANDLER_COUNT";
    public static final String LOG_FILEHANDLER_APPEND = "LOG_FILEHANDLER_APPEND";
    public static final String LOG_FILEHANDLER_PATH = "LOG_FILEHANDLER_PATH";
    public static final String DEFAULT_LOG_HANDLER = "CONSOLE,FILE";
    public static final String DEFAULT_LOG_LEVEL = "INFO";
    public static final String LOG_HANDLER = "LOG_HANDLER";
    public static final String LOG_LEVEL = "LOG_LEVEL";
    public static final String DEFAULT_FILEHANDLER_PATH = "simplelogger-%u-%g.log";
    public static final String LOGGER_NAME = "com.marklogic.ps";
    public static final String LOG_FORMATTER = "LOG_FORMATTER";
    private static final Map<String, SimpleLogger> loggers = Collections.synchronizedMap(new Hashtable());

    SimpleLogger(String name) {
        super(name, null);
        loggers.put(name, this);
        this.setParent(Logger.getLogger(""));
    }

    SimpleLogger(String name, String resBundle) {
        super(name, resBundle);
        loggers.put(name, this);
        this.setParent(Logger.getLogger(""));
    }

    public static SimpleLogger getSimpleLogger() {
        return SimpleLogger.getSimpleLogger(LOGGER_NAME);
    }

    public static SimpleLogger getSimpleLogger(String name) {
        return SimpleLogger.getSimpleLogger(name, null);
    }

    public static SimpleLogger getSimpleLogger(String name, String resBundle) {
        SimpleLogger obj = loggers.get(name);
        if (obj == null) {
            obj = resBundle != null ? new SimpleLogger(name, resBundle) : new SimpleLogger(name);
        }
        return obj;
    }

    public void configureLogger(Properties prop) {
        if (prop == null) {
            System.err.println("WARNING: null properties. Cannot configure logger");
            return;
        }
        this.setUseParentHandlers(false);
        String logLevel = prop.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL);
        String[] newHandlers = prop.getProperty(LOG_HANDLER, DEFAULT_LOG_HANDLER).split(",");
        String logFilePath = prop.getProperty(LOG_FILEHANDLER_PATH, DEFAULT_FILEHANDLER_PATH);
        boolean logFileAppend = Boolean.parseBoolean(prop.getProperty(LOG_FILEHANDLER_APPEND, "true"));
        int logFileCount = Integer.parseInt(prop.getProperty(LOG_FILEHANDLER_COUNT, "1"));
        int logFileLimit = Integer.parseInt(prop.getProperty(LOG_FILEHANDLER_LIMIT, "0"));
        String logFormatter = prop.getProperty(LOG_FORMATTER, null);
        Handler handler = null;
        if (newHandlers != null && newHandlers.length > 0) {
            Handler[] oldHandlers = this.getHandlers();
            int size = oldHandlers.length;
            if (size < newHandlers.length) {
                size = newHandlers.length;
            }
            for (int i = 0; i < size; ++i) {
                if (i >= newHandlers.length) {
                    this.removeHandler(oldHandlers[i]);
                    continue;
                }
                if (i < oldHandlers.length && oldHandlers[i] != null && (newHandlers[i].equals("CONSOLE") && oldHandlers[i] instanceof ConsoleHandler || newHandlers[i].equals("FILE") && oldHandlers[i] instanceof FileHandler || newHandlers[i].equals(oldHandlers[i].getClass().getSimpleName()))) continue;
                if (i < oldHandlers.length) {
                    this.removeHandler(oldHandlers[i]);
                }
                if (newHandlers[i].equals("FILE")) {
                    System.err.println("logging to file " + logFilePath);
                    try {
                        handler = new FileHandler(logFilePath, logFileLimit, logFileCount, logFileAppend);
                    }
                    catch (IOException | SecurityException e) {
                        e.printStackTrace();
                        System.err.println("cannot configure logging: exiting");
                        Runtime.getRuntime().exit(-1);
                    }
                } else if (newHandlers[i].equals("CONSOLE")) {
                    System.err.println("logging to " + newHandlers[i]);
                    handler = new ConsoleHandler();
                } else {
                    try {
                        Class<Handler> lhc = Class.forName(newHandlers[i], true, ClassLoader.getSystemClassLoader()).asSubclass(Handler.class);
                        System.err.println("logging to class " + newHandlers[i]);
                        Constructor<Handler> con = lhc.getConstructor(new Class[0]);
                        handler = con.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        System.err.println("unrecognized LOG_HANDLER: " + newHandlers[i]);
                        e.printStackTrace();
                        System.err.println("cannot configure logging: exiting");
                        Runtime.getRuntime().exit(-1);
                    }
                }
                if (handler == null) continue;
                this.addHandler(handler);
            }
        } else {
            handler = new ConsoleHandler();
            this.addHandler(handler);
        }
        if (logLevel != null) {
            Level level = Level.parse(logLevel);
            if (level != null) {
                this.setLevel(level);
                Handler[] handlerArray = this.getHandlers();
                int n = handlerArray.length;
                for (int e = 0; e < n; ++e) {
                    Handler _handler = handlerArray[e];
                    _handler.setLevel(level);
                }
            }
            this.fine("logging set to " + this.getLevel());
        }
        for (Handler _handler : this.getHandlers()) {
            Formatter f = null;
            if ("SimpleFormatter".equals(logFormatter)) {
                f = new SimpleFormatter();
            }
            if (null == logFormatter) {
                f = new OneLineFormatter();
            }
            _handler.setFormatter(f);
        }
        this.info("setting up " + this + " for: " + this.getName());
    }

    public void logException(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        super.log(Level.SEVERE, message, exception);
    }

    @Override
    public void setProperties(Properties properties) {
        this.configureLogger(properties);
    }
}

