/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class Utilities {
    private static final int BUFFER_SIZE = 32768;

    public static String getPathExtension(String path) {
        return path.replaceFirst(".*\\.([^\\.]+)$", "$1");
    }

    public static String join(List<String> items, String delim) {
        return Utilities.join(items.toArray(), delim);
    }

    public static String join(Object[] items, String delim) {
        StringBuilder rval = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i == 0) {
                rval = new StringBuilder("" + items[0]);
                continue;
            }
            rval.append(delim).append(items[i]);
        }
        return rval.toString();
    }

    public static String join(String[] items, String delim) {
        if (null == items) {
            return null;
        }
        StringBuilder rval = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i == 0) {
                rval = new StringBuilder(items[0]);
                continue;
            }
            rval.append(delim).append(items[i]);
        }
        return rval.toString();
    }

    public static String escapeXml(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IOException("null InputStream");
        }
        if (out == null) {
            throw new IOException("null OutputStream");
        }
        long totalBytes = 0L;
        int len = 0;
        byte[] buf = new byte[32768];
        while ((len = in.read(buf, 0, 32768)) > -1) {
            out.write(buf, 0, len);
            out.flush();
            totalBytes += (long)len;
        }
        return totalBytes;
    }

    public static void copy(File in, File out) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(in);){
            FileOutputStream outputStream = new FileOutputStream(out);
            Utilities.copy(inputStream, (OutputStream)outputStream);
        }
    }

    public static long copy(Reader in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IOException("null Reader");
        }
        if (out == null) {
            throw new IOException("null OutputStream");
        }
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        long len = Utilities.copy(in, writer);
        out.flush();
        return len;
    }

    public static long copy(Reader in, Writer out) throws IOException {
        if (in == null) {
            throw new IOException("null Reader");
        }
        if (out == null) {
            throw new IOException("null Writer");
        }
        long totalChars = 0L;
        int len = 0;
        char[] cbuf = new char[32768];
        while ((len = in.read(cbuf, 0, 32768)) > -1) {
            out.write(cbuf, 0, len);
            out.flush();
            totalChars += (long)len;
        }
        if (1L > totalChars) {
            throw new IOException("expected at least 1 Chars, copied only " + totalChars);
        }
        return totalChars;
    }

    public static void copy(String inFilePath, String outFilePath) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(inFilePath);
             FileOutputStream fileOutputStream = new FileOutputStream(outFilePath);){
            Utilities.copy(fileInputStream, (OutputStream)fileOutputStream);
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            boolean success = file.delete();
            if (!success) {
                throw new IOException("error deleting " + file.getCanonicalPath());
            }
            return;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                Utilities.deleteFile(child);
            }
        }
        if (file.exists()) {
            file.delete();
        }
    }

    public static boolean stringToBoolean(String str) {
        return Utilities.stringToBoolean(str, false);
    }

    public static boolean stringToBoolean(String str, boolean defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        String lcStr = str.toLowerCase();
        return !"".equals(str) && !"0".equals(str) && !"f".equals(lcStr) && !"false".equals(lcStr) && !"n".equals(lcStr) && !"no".equals(lcStr);
    }

    public static void deleteFile(String path) throws IOException {
        Utilities.deleteFile(new File(path));
    }

    public static String buildModulePath(Class<?> clazz) {
        return "/" + clazz.getName().replace('.', '/') + ".xqy";
    }

    public static String buildModulePath(Package pkg, String name) {
        return "/" + pkg.getName().replace('.', '/') + "/" + name + (name.endsWith(".xqy") ? "" : ".xqy");
    }

    public static String cat(Reader r) throws IOException {
        int size;
        StringBuilder rv = new StringBuilder();
        char[] buf = new char[32768];
        while ((size = r.read(buf)) > 0) {
            rv.append(buf, 0, size);
        }
        return rv.toString();
    }

    public static byte[] cat(File contentFile) throws IOException {
        return Utilities.cat(new FileInputStream(contentFile));
    }

    public static byte[] cat(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(32768);
        Utilities.copy(is, (OutputStream)bos);
        return bos.toByteArray();
    }

    public static long getSize(InputStream is) throws IOException {
        long size = 0L;
        int b = 0;
        byte[] buf = new byte[32768];
        while ((b = is.read(buf)) > 0) {
            size += (long)b;
        }
        return size;
    }

    public static long getSize(Reader r) throws IOException {
        long size = 0L;
        int b = 0;
        char[] buf = new char[32768];
        while ((b = r.read(buf)) > 0) {
            size += (long)b;
        }
        return size;
    }

    public static boolean isNotEmpty(String[] array) {
        return !Utilities.isEmpty(array);
    }

    public static boolean isEmpty(String[] array) {
        return array == null || array.length == 0;
    }
}

