/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.timing;

public class TimedEvent {
    private long bytes = 0L;
    private long duration = -1L;
    private boolean error = false;
    private final long start;
    private String description = null;

    public TimedEvent() {
        this.start = System.nanoTime();
    }

    public TimedEvent(boolean error) {
        this.error = error;
        this.start = System.nanoTime();
    }

    public long getBytes() {
        return this.bytes;
    }

    public long stop() {
        return this.stop(this.bytes < 0L ? 0L : this.bytes, false);
    }

    public long stop(long bytes) {
        return this.stop(bytes, false);
    }

    public void stop(boolean error) {
        this.stop(-1L, error);
    }

    public long stop(long bytes, boolean error) {
        if (this.duration > -1L) {
            return this.duration;
        }
        this.duration = System.nanoTime() - this.start;
        assert (this.duration > 0L);
        if (bytes > -1L) {
            this.bytes = bytes;
        }
        this.error = error;
        return this.duration;
    }

    public long getDuration() {
        if (this.duration < 0L) {
            return System.nanoTime() - this.start;
        }
        return this.duration;
    }

    public boolean isError() {
        return this.error;
    }

    public long getStart() {
        return this.start;
    }

    public void increment(long bytes) {
        this.bytes += bytes;
    }

    public void setError(boolean bool) {
        this.error = bool;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

