/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.timing;

import com.marklogic.ps.timing.TimedEvent;
import com.marklogic.ps.timing.TimedEventDurationComparator;
import java.util.ArrayList;
import java.util.List;

public class Timer {
    public static final int BYTES_PER_KILOBYTE = 1024;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int NANOSECONDS_PER_MICROSECOND = 1000;
    public static final int MICROSECONDS_PER_MILLISECOND = 1000;
    public static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    public static final int NANOSECONDS_PER_SECOND = 1000000000;
    private long errors = 0L;
    private long bytes = 0L;
    private long duration = -1L;
    private final List<TimedEvent> events = new ArrayList<TimedEvent>();
    private final long start = System.nanoTime();
    private long eventCount = 0L;
    private long lastMessageTime = System.currentTimeMillis();
    private long lastEventCount = 0L;
    private long lastBytes = 0L;

    public void add(TimedEvent event) {
        this.add(event, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimedEvent event, boolean keepEvent) {
        event.stop();
        List<TimedEvent> list = this.events;
        synchronized (list) {
            this.bytes += event.getBytes();
            if (event.isError()) {
                ++this.errors;
            }
            ++this.eventCount;
            if (keepEvent) {
                this.events.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Timer timer) {
        timer.stop();
        List<TimedEvent> list = this.events;
        synchronized (list) {
            this.bytes += timer.getBytes();
            this.errors += timer.getErrorCount();
            this.events.addAll(timer.events);
            this.eventCount += timer.eventCount;
        }
    }

    public long getBytes() {
        return this.bytes;
    }

    public double getBytesPerSecond() {
        return (double)this.bytes / this.getDurationSeconds();
    }

    public long getEventCount() {
        return this.eventCount;
    }

    public long getSuccessfulEventCount() {
        return this.eventCount - this.errors;
    }

    public long getErrorCount() {
        return this.errors;
    }

    public long getDuration() {
        if (this.duration < 0L) {
            return System.nanoTime() - this.start;
        }
        return this.duration;
    }

    public long getMeanOfEvents() {
        if (this.eventCount < 1L) {
            return 0L;
        }
        long sum = 0L;
        int i = 0;
        while ((long)i < this.eventCount) {
            sum += this.events.get(i).getDuration();
            ++i;
        }
        return Math.round((double)sum / (double)this.eventCount);
    }

    public long getPercentileDuration(int p) {
        if (this.eventCount < 1L) {
            return 0L;
        }
        double size = this.eventCount;
        TimedEventDurationComparator c = new TimedEventDurationComparator();
        this.events.sort(c);
        int pidx = (int)((double)p * size * 0.01);
        return this.events.get(pidx).getDuration();
    }

    public long getMaxDuration() {
        long max = 0L;
        int i = 0;
        while ((long)i < this.eventCount) {
            max = Math.max(max, this.events.get(i).getDuration());
            ++i;
        }
        return max;
    }

    public long getMinDuration() {
        long min = Integer.MAX_VALUE;
        int i = 0;
        while ((long)i < this.eventCount) {
            min = Math.min(min, this.events.get(i).getDuration());
            ++i;
        }
        return min;
    }

    public long getMeanOverall() {
        return this.getDuration() / this.eventCount;
    }

    public long getStart() {
        return this.start;
    }

    public long getKiloBytes() {
        return (long)((double)this.bytes / 1024.0);
    }

    public double getKilobytesPerSecond() {
        return (double)this.bytes / 1024.0 / this.getDurationSeconds();
    }

    public double getEventsPerSecond() {
        return (double)this.eventCount / this.getDurationSeconds();
    }

    public long stop() {
        return this.stop(System.nanoTime());
    }

    public synchronized long stop(long l) {
        if (this.duration < 0L) {
            this.duration = l - this.start;
        }
        return this.duration;
    }

    public void incrementEventCount(int count, boolean successful) {
        this.eventCount += (long)count;
        if (!successful) {
            ++this.errors;
        }
    }

    public void incrementEventCount() {
        this.incrementEventCount(1, true);
    }

    public void incrementEventCount(int count) {
        this.incrementEventCount(count, true);
    }

    public void incrementEventCount(boolean successful) {
        this.incrementEventCount(1, successful);
    }

    public double getDurationMilliseconds() {
        return (double)this.getDuration() / 1000000.0;
    }

    public double getDurationSeconds() {
        return (double)this.getDuration() / 1.0E9;
    }

    public String getProgressMessage(boolean rawValues) {
        return (rawValues ? this.eventCount + " events, " + this.getBytes() + " B in " + this.getDurationSeconds() + " s, " : "") + Math.round(this.getEventsPerSecond()) + " events/s, " + Math.round(this.getKilobytesPerSecond()) + " kB/s";
    }

    public String getProgressMessage() {
        return this.getProgressMessage(false);
    }

    public String getCurrProgressMessage() {
        String msg = null;
        long currMessageTime = System.currentTimeMillis();
        long interval = currMessageTime - this.lastMessageTime;
        if (interval >= 100L) {
            long currEventCount = this.getEventCount();
            long currBytes = this.getBytes();
            long currEventRate = 1000L * (currEventCount - this.lastEventCount) / interval;
            long currBytesRate = 1000L * (currBytes - this.lastBytes) / 1024L / interval;
            msg = "current rate:  " + currEventRate + " events/s, " + currBytesRate + " kB/s";
            this.lastMessageTime = currMessageTime;
            this.lastEventCount = currEventCount;
            this.lastBytes = currBytes;
        }
        return msg;
    }
}

