/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AbstractConfiguration {
    protected static final String DEFAULT_SUFFIX = "_DEFAULT";
    protected static final String KEY_SUFFIX = "_KEY";
    protected static SimpleLogger logger;
    protected final Map<String, Object> defaults = new HashMap<String, Object>();
    protected Properties properties = new Properties();

    protected void setDefaults() throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = this.getClass().getFields()) {
            String key;
            String name = field.getName();
            if (name.endsWith(KEY_SUFFIX)) {
                key = (String)field.get(this);
                if (this.defaults.containsKey(key)) continue;
                this.defaults.put(key, null);
                logger.fine(key + "=(null)");
                continue;
            }
            if (!name.endsWith(DEFAULT_SUFFIX)) continue;
            key = (String)this.getClass().getField(name.substring(0, name.length() - DEFAULT_SUFFIX.length()) + KEY_SUFFIX).get(this);
            this.defaults.put(key, field.get(this));
            logger.fine(key + "=" + this.defaults.get(key));
        }
    }

    public void load(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    public void load(InputStream stream) throws IOException {
        Properties newProperties = new Properties();
        newProperties.load(stream);
        this.load(newProperties);
    }

    protected void validateProperties() {
        Properties validated = new Properties();
        Enumeration<?> keys = this.properties.propertyNames();
        String ignorePrefixPatterns = "^(awt|file|ftp|http|https|java|line|mrj|os|path|sun|user)\\..+";
        String ignorePatterns = "^(gopherProxySet|socksNonProxyHosts)$";
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.matches(ignorePatterns) || key.matches(ignorePrefixPatterns)) {
                logger.fine("known system key: ignoring " + key);
                continue;
            }
            if (!this.defaults.containsKey(key)) {
                logger.warning("unknown key: skipping " + key);
                continue;
            }
            String value = this.properties.getProperty(key);
            logger.info("using " + key + "=" + value);
            validated.setProperty(key, value);
        }
        this.applyDefaults(validated);
        this.properties = validated;
    }

    private void applyDefaults(Properties props) {
        for (String key : this.defaults.keySet()) {
            Object value;
            if (props.containsKey(key) || null == (value = this.defaults.get(key))) continue;
            logger.fine("applying default " + key + "=" + value);
            props.setProperty(key, value.toString());
        }
    }

    public SimpleLogger getLogger() {
        return logger;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setLogger(SimpleLogger logger) {
        AbstractConfiguration.logger = logger;
    }
}

