/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.WriterInterface;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import com.marklogic.xcc.ContentPermission;
import java.util.Collection;

public abstract class AbstractWriter
implements WriterInterface {
    protected final SimpleLogger logger;
    protected final Configuration configuration;
    protected final String[] placeKeys;
    protected final boolean skipExisting;
    protected final boolean repairInputXml;
    protected final Collection<ContentPermission> permissionRoles;
    protected final boolean copyProperties;
    protected final String[] outputFormatFilters;

    protected AbstractWriter(Configuration configuration) {
        this.configuration = configuration;
        this.logger = configuration.getLogger();
        this.copyProperties = configuration.isCopyProperties();
        this.outputFormatFilters = configuration.getOutputFormatFilters();
        this.placeKeys = configuration.getPlaceKeys();
        this.permissionRoles = configuration.getPermissionRoles();
        this.repairInputXml = configuration.isRepairInputXml();
        this.skipExisting = configuration.isSkipExisting();
    }

    @Override
    public int write(String[] outputUri, byte[][] contentBytes, XQSyncDocumentMetadata[] metadata) throws SyncException {
        int bytes = 0;
        if (null != outputUri) {
            for (int i = 0; i < outputUri.length; ++i) {
                bytes += this.write(outputUri[i], contentBytes[i], metadata[i]);
            }
        }
        return bytes;
    }
}

