/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.timing.TimedEvent;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.Monitor;
import com.marklogic.ps.xqsync.PackageReader;
import com.marklogic.ps.xqsync.ReaderInterface;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.TaskFactory;
import com.marklogic.ps.xqsync.WriterInterface;
import com.marklogic.ps.xqsync.XQSyncDocument;
import java.util.concurrent.Callable;

public class CallableSync
implements Callable<TimedEvent[]> {
    protected final String[] inputUris;
    protected final TaskFactory taskFactory;
    protected final Monitor monitor;

    public CallableSync(TaskFactory taskFactory, String[] uris) {
        this.taskFactory = taskFactory;
        this.inputUris = uris;
        this.monitor = taskFactory.getMonitor();
    }

    @Override
    public TimedEvent[] call() throws Exception {
        this.initialize();
        this.monitor.checkThrottle();
        TimedEvent[] te = new TimedEvent[this.inputUris.length];
        for (int i = 0; i < this.inputUris.length; ++i) {
            if (null == this.inputUris[i]) continue;
            te[i] = new TimedEvent();
        }
        Configuration configuration = this.taskFactory.getConfiguration();
        SimpleLogger logger = configuration.getLogger();
        ReaderInterface reader = this.taskFactory.getReader();
        if (null == reader) {
            throw new FatalException("null reader");
        }
        WriterInterface writer = this.taskFactory.getWriter();
        if (null == writer) {
            throw new FatalException("null writer");
        }
        logger.fine("starting sync of " + this.inputUris.length + ": " + this.inputUris[0]);
        try {
            XQSyncDocument document = new XQSyncDocument(this.inputUris, reader, writer, configuration);
            int bytesWritten = document.sync();
            for (int i = 0; i < te.length; ++i) {
                if (null == te[i]) continue;
                te[i].stop(0 == i ? (long)bytesWritten : 0L);
                te[i].setDescription(document.getOutputUri(i));
            }
            TimedEvent[] timedEventArray = te;
            return timedEventArray;
        }
        catch (SyncException e) {
            for (String uris : this.inputUris) {
                logger.severe("sync failed for: " + uris);
            }
            if (reader instanceof PackageReader) {
                logger.warning("error in input package " + ((PackageReader)reader).getPath());
            }
            throw e;
        }
        catch (Throwable t) {
            for (String uris : this.inputUris) {
                logger.severe("sync failed for: " + uris);
            }
            throw new FatalException(t);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
            Thread.yield();
        }
    }

    private void initialize() {
        if (null == this.inputUris) {
            throw new NullPointerException("missing required field: inputUri");
        }
        if (null == this.taskFactory) {
            throw new NullPointerException("missing required field: taskFactory");
        }
    }
}

