/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.Connection;
import com.marklogic.ps.Session;
import com.marklogic.ps.Utilities;
import com.marklogic.ps.xqsync.AbstractConfiguration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.FilePathWriter;
import com.marklogic.ps.xqsync.ReaderInterface;
import com.marklogic.ps.xqsync.SessionReader;
import com.marklogic.ps.xqsync.SessionWriter;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.WriterInterface;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.UnimplementedFeatureException;
import com.marklogic.xcc.exceptions.XccException;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class Configuration
extends AbstractConfiguration {
    public static final String ALLOW_EMPTY_METADATA_KEY = "ALLOW_EMPTY_METADATA";
    public static final String ALLOW_EMPTY_METADATA_DEFAULT = "false";
    public static final String CONFIGURATION_CLASSNAME_KEY = "CONFIGURATION_CLASSNAME";
    public static final String CONFIGURATION_CLASSNAME_DEFAULT = Configuration.class.getCanonicalName();
    public static final String COPY_COLLECTIONS_KEY = "COPY_COLLECTIONS";
    public static final String COPY_COLLECTIONS_DEFAULT = "true";
    public static final String COPY_PROPERTIES_KEY = "COPY_PROPERTIES";
    public static final String COPY_PROPERTIES_DEFAULT = "true";
    public static final String COPY_PERMISSIONS_KEY = "COPY_PERMISSIONS";
    public static final String COPY_PERMISSIONS_DEFAULT = "true";
    public static final String COPY_QUALITY_KEY = "COPY_QUALITY";
    public static final String COPY_QUALITY_DEFAULT = "true";
    public static final String DELETE_COLLECTION_KEY = "DELETE_COLLECTION";
    public static final String FATAL_ERRORS_KEY = "FATAL_ERRORS";
    public static final boolean FATAL_ERRORS_DEFAULT_BOOLEAN = true;
    public static final String INPUT_BATCH_SIZE_KEY = "INPUT_BATCH_SIZE";
    public static final String INPUT_BATCH_SIZE_DEFAULT = "1";
    public static final String OUTPUT_BATCH_SIZE_KEY = "OUTPUT_BATCH_SIZE";
    public static final String OUTPUT_BATCH_SIZE_DEFAULT = "1";
    public static final String USE_MULTI_STMT_TXN_KEY = "USE_MULTI_STMT_TXN";
    public static final String USE_MULTI_STMT_TXN_DEFAULT = "false";
    public static final String ENCODE_OUTPUT_URI_KEY = "ENCODE_OUTPUT_URI";
    public static final String ENCODE_OUTPUT_URI_DEFAULT = "false";
    public static final String USE_RANDOM_OUTPUT_URI_KEY = "USE_RANDOM_OUTPUT_URI";
    public static final String USE_RANDOM_OUTPUT_URI_DEFAULT = "false";
    public static final String INPUT_CACHABLE_KEY = "INPUT_QUERY_CACHABLE";
    public static final String INPUT_CACHABLE_DEFAULT = "false";
    public static final String INPUT_COLLECTION_URI_KEY = "INPUT_COLLECTION_URI";
    public static final String INPUT_CONNECTION_STRING_KEY = "INPUT_CONNECTION_STRING";
    public static final String INPUT_DIRECTORY_URI_KEY = "INPUT_DIRECTORY_URI";
    public static final String INPUT_DOCUMENT_URIS_KEY = "INPUT_DOCUMENT_URIS";
    public static final String INPUT_MODULE_URI_KEY = "INPUT_MODULE_URI";
    public static final String INPUT_PACKAGE_KEY = "INPUT_PACKAGE";
    public static final String INPUT_PATH_KEY = "INPUT_PATH";
    public static final String INPUT_QUERY_KEY = "INPUT_QUERY";
    public static final String INPUT_QUERY_BUFFER_BYTES_KEY = "INPUT_QUERY_BUFFER_BYTES";
    public static final String INPUT_QUERY_BUFFER_BYTES_DEFAULT = "0";
    public static final String INPUT_RESULT_BUFFER_SIZE_KEY = "INPUT_RESULT_BUFFER_SIZE";
    public static final String INPUT_RESULT_BUFFER_SIZE_DEFAULT = "0";
    public static final String INPUT_START_POSITION_KEY = "INPUT_START_POSITION";
    public static final String INPUT_TIMESTAMP_AUTO = "#AUTO";
    public static final String INPUT_TIMESTAMP_KEY = "INPUT_TIMESTAMP";
    public static final String INPUT_INDENTED_KEY = "INPUT_INDENTED";
    public static final String MAX_RETRIES_DEFAULT = "5";
    public static final String MAX_RETRIES_KEY = "MAX_RETRIES";
    public static final String OUTPUT_COLLECTIONS_KEY = "OUTPUT_COLLECTIONS";
    public static final String OUTPUT_CONNECTION_STRING_KEY = "OUTPUT_CONNECTION_STRING";
    public static final String OUTPUT_FILTER_FORMATS_KEY = "OUTPUT_FILTER_FORMATS";
    public static final String OUTPUT_FORESTS_KEY = "OUTPUT_FORESTS";
    public static final String OUTPUT_PACKAGE_KEY = "OUTPUT_PACKAGE";
    public static final String OUTPUT_PATH_KEY = "OUTPUT_PATH";
    public static final String QUEUE_SIZE_KEY = "QUEUE_SIZE";
    public static final String ROLES_READ_KEY = "ROLES_READ";
    public static final String ROLES_UPDATE_KEY = "ROLES_UPDATE";
    public static final String ROLES_INSERT_KEY = "ROLES_INSERT";
    public static final String ROLES_EXECUTE_KEY = "ROLES_EXECUTE";
    public static final String REPAIR_INPUT_XML_KEY = "REPAIR_INPUT_XML";
    public static final String REPAIR_INPUT_XML_DEFAULT = "false";
    public static final String REPAIR_MULTIPLE_DOCUMENTS_PER_URI_DEFAULT = "false";
    public static final String REPAIR_MULTIPLE_DOCUMENTS_PER_URI_KEY = "REPAIR_MULTIPLE_DOCUMENTS_PER_URI";
    public static final String SKIP_EXISTING_KEY = "SKIP_EXISTING";
    public static final String THREADS_KEY = "THREADS";
    public static final String THREADS_DEFAULT = "1";
    public static final String THROTTLE_EVENTS_KEY = "THROTTLE_EVENTS_PER_SECOND";
    public static final String THROTTLE_EVENTS_DEFAULT = "0";
    public static final String THROTTLE_BYTES_KEY = "THROTTLE_BYTES_PER_SECOND";
    public static final String THROTTLE_BYTES_DEFAULT = "0";
    public static final String URI_PREFIX_KEY = "URI_PREFIX";
    public static final String URI_SUFFIX_KEY = "URI_SUFFIX";
    public static final String URI_PREFIX_STRIP_KEY = "URI_PREFIX_STRIP";
    public static final String URI_SUFFIX_STRIP_KEY = "URI_SUFFIX_STRIP";
    public static final String USE_IN_MEMORY_URI_QUEUE_KEY = "USE_IN_MEMORY_URI_QUEUE";
    public static final String USE_IN_MEMORY_URI_QUEUE_DEFAULT = "false";
    public static final String TMP_DIR_KEY = "TMP_DIR";
    public static final String TMP_DIR_DEFAULT = null;
    public static final String URI_QUEUE_FILE_KEY = "URI_QUEUE_FILE";
    public static final String URI_QUEUE_FILE_DEFAULT = null;
    public static final String KEEP_URI_QUEUE_FILE_KEY = "KEEP_URI_QUEUE_FILE";
    public static final String KEEP_URI_QUEUE_FILE_DEFAULT = "false";
    public static final String PRINT_CURRENT_RATE_KEY = "PRINT_CURRENT_RATE";
    public static final String PRINT_CURRENT_RATE_DEFAULT = "false";
    public static final String USE_IN_FOREST_EVAL_KEY = "USE_IN_FOREST_EVAL";
    public static final String USE_IN_FOREST_EVAL_DEFAULT = "false";
    public static final String CHECKSUM_MODULE_KEY = "CHECKSUM_MODULE";
    protected static final String CSV_SCSV_SSV_REGEX = "[,;\\s]+";
    protected static final String XCC_PREFIX = "xcc://";
    protected static final String XCCS_PREFIX = "xccs://";
    protected static final String XCC_PREFIX_OLD = "xdbc://";
    protected final Collection<ContentPermission> permissionRoles = new ArrayList<ContentPermission>();
    protected String[] placeKeys = null;
    protected Connection[] outputConnection = null;
    protected String outputPath;
    protected boolean firstConfiguration = true;
    protected Connection inputConnection;
    protected String inputPath;
    protected String inputPackagePath;
    protected String outputPackagePath;
    protected Long startPosition;
    protected double throttledEventsPerSecond;
    protected int throttledBytesPerSecond;
    protected String uriPrefix;
    protected String[] outputCollections;
    protected String[] outputFormatFilters;
    protected BigInteger timestamp;
    private int outputConnectionCount = 0;
    protected Map<String, BigInteger> forestMap = null;

    public synchronized void setProperties(Properties properties) {
        this.properties = properties;
        if (null == logger) {
            throw new NullPointerException("null logger");
        }
        logger.setProperties(properties);
    }

    public void configure() throws Exception {
        String outputCollectionsString;
        String outputFormatFilterString;
        if (!this.firstConfiguration) {
            return;
        }
        this.firstConfiguration = false;
        if (null == logger) {
            throw new NullPointerException("null logger");
        }
        if (this.properties == null || !this.properties.keys().hasMoreElements()) {
            logger.warning("null or empty properties");
        }
        logger.info("first-time setup");
        logger.configureLogger(this.properties);
        try {
            this.setDefaults();
        }
        catch (Exception e) {
            throw new FatalException(e);
        }
        this.validateProperties();
        this.configureInput();
        this.configureOutput();
        this.configureTimestamp(this.properties.getProperty(INPUT_TIMESTAMP_KEY));
        this.configureThrottling();
        String startPositionString = this.properties.getProperty(INPUT_START_POSITION_KEY);
        if (startPositionString != null) {
            this.startPosition = new Long(startPositionString);
            if (this.startPosition < 2L) {
                this.startPosition = null;
            }
        }
        this.uriPrefix = this.properties.getProperty(URI_PREFIX_KEY);
        this.getPermissionRole(ROLES_READ_KEY, ContentPermission.READ);
        this.getPermissionRole(ROLES_UPDATE_KEY, ContentPermission.UPDATE);
        this.getPermissionRole(ROLES_INSERT_KEY, ContentPermission.INSERT);
        this.getPermissionRole(ROLES_EXECUTE_KEY, ContentPermission.EXECUTE);
        String placeKeysString = this.properties.getProperty(OUTPUT_FORESTS_KEY);
        if (placeKeysString != null) {
            this.placeKeys = placeKeysString.split(CSV_SCSV_SSV_REGEX);
            logger.info("placeKeys = " + placeKeysString);
        }
        if (null != (outputFormatFilterString = this.properties.getProperty(OUTPUT_FILTER_FORMATS_KEY)) && null != (outputFormatFilterString = outputFormatFilterString.trim()) && outputFormatFilterString.length() > 1) {
            this.outputFormatFilters = outputFormatFilterString.split(CSV_SCSV_SSV_REGEX);
            logger.finest(this + " outputFormatFilters = " + Utilities.join(this.outputFormatFilters, ","));
        }
        if (null != (outputCollectionsString = this.properties.getProperty(OUTPUT_COLLECTIONS_KEY)) && null != (outputCollectionsString = outputCollectionsString.trim()) && outputCollectionsString.length() > 1) {
            this.outputCollections = outputCollectionsString.split(CSV_SCSV_SSV_REGEX);
            logger.finest(this + " outputCollections = " + Utilities.join(this.outputCollections, ","));
        }
    }

    private void configureInput() throws IOException, URISyntaxException, XccException, SyncException, KeyManagementException, NoSuchAlgorithmException {
        this.inputPackagePath = this.properties.getProperty(INPUT_PACKAGE_KEY);
        if (null != this.inputPackagePath) {
            logger.info("input from package: " + this.inputPackagePath);
            return;
        }
        this.inputPath = this.properties.getProperty(INPUT_PATH_KEY);
        if (this.inputPath != null) {
            logger.info("input from path: " + this.inputPath);
        } else {
            String inputConnectionString = this.properties.getProperty(INPUT_CONNECTION_STRING_KEY);
            if (inputConnectionString == null) {
                throw new IOException("missing required property: INPUT_CONNECTION_STRING");
            }
            if (!this.isValidConnectionString(inputConnectionString)) {
                throw new SyncException("unsupported connection string: " + inputConnectionString);
            }
            String[] inputStrings = inputConnectionString.split(CSV_SCSV_SSV_REGEX);
            URI[] inputUri = new URI[inputStrings.length];
            logger.info("input from connection: ");
            for (int i = 0; i < inputUri.length; ++i) {
                inputUri[i] = new URI(inputStrings[i]);
                String[] splitStr = inputStrings[i].split("@");
                logger.info("input connection string: " + splitStr[1]);
            }
            this.inputConnection = new Connection(inputUri);
        }
    }

    protected void configureOutput() throws Exception {
        this.outputPackagePath = this.properties.getProperty(OUTPUT_PACKAGE_KEY);
        if (null != this.outputPackagePath) {
            logger.info("output to package: " + this.outputPackagePath);
        } else {
            this.outputPath = this.properties.getProperty(OUTPUT_PATH_KEY);
            if (null != this.outputPath) {
                logger.info("output to path: " + this.outputPath);
                File outputFile = new File(this.outputPath);
                Configuration.ensureFileExists(outputFile);
                this.outputPath = outputFile.getCanonicalPath();
            } else {
                String outputConnectionString = this.properties.getProperty(OUTPUT_CONNECTION_STRING_KEY);
                if (outputConnectionString == null) {
                    throw new IOException("missing required property: OUTPUT_CONNECTION_STRING");
                }
                if (!this.isValidConnectionString(outputConnectionString)) {
                    throw new UnimplementedFeatureException("unsupported connection string: " + outputConnectionString);
                }
                String[] outputConnectionStrings = outputConnectionString.split(CSV_SCSV_SSV_REGEX);
                this.outputConnection = new Connection[outputConnectionStrings.length];
                logger.info("output to connection: ");
                for (int i = 0; i < this.outputConnection.length; ++i) {
                    this.outputConnection[i] = new Connection(new URI(outputConnectionStrings[i]));
                    String[] splitStr = outputConnectionStrings[i].split("@");
                    logger.info("output connection string: " + splitStr[1]);
                }
            }
        }
    }

    void configureThrottling() {
        this.throttledEventsPerSecond = Double.parseDouble(this.properties.getProperty(THROTTLE_EVENTS_KEY));
        this.throttledBytesPerSecond = Integer.parseInt(this.properties.getProperty(THROTTLE_BYTES_KEY));
    }

    private void configureTimestamp(String timestampString) throws RequestException {
        if (null != timestampString) {
            Session sess = this.newInputSession();
            if (null == sess) {
                logger.warning("ignoring INPUT_TIMESTAMP=" + timestampString + " because " + INPUT_CONNECTION_STRING_KEY + " is not set.");
            } else if (timestampString.startsWith("#")) {
                if (INPUT_TIMESTAMP_AUTO.equals(timestampString)) {
                    this.timestamp = sess.getCurrentServerPointInTime();
                } else {
                    logger.warning("ignoring unknown timestamp " + timestampString);
                }
            } else {
                this.timestamp = new BigInteger(timestampString);
            }
            if (null != this.timestamp) {
                logger.info("using timestamp " + this.timestamp);
            }
        }
    }

    protected boolean isValidConnectionString(String connectionString) {
        return connectionString.startsWith(XCC_PREFIX) || connectionString.startsWith(XCCS_PREFIX) || connectionString.startsWith(XCC_PREFIX_OLD);
    }

    public boolean isCopyCollections() {
        return Utilities.stringToBoolean(this.properties.getProperty(COPY_COLLECTIONS_KEY));
    }

    public boolean isCopyPermissions() {
        return Utilities.stringToBoolean(this.properties.getProperty(COPY_PERMISSIONS_KEY));
    }

    public boolean isCopyProperties() {
        return Utilities.stringToBoolean(this.properties.getProperty(COPY_PROPERTIES_KEY));
    }

    public boolean isCopyQuality() {
        return Utilities.stringToBoolean(this.properties.getProperty(COPY_QUALITY_KEY));
    }

    public boolean isFatalErrors() {
        return Utilities.stringToBoolean(this.properties.getProperty(FATAL_ERRORS_KEY));
    }

    public boolean isRepairMultipleDocumentsPerUri() {
        return Utilities.stringToBoolean(this.properties.getProperty(REPAIR_MULTIPLE_DOCUMENTS_PER_URI_KEY));
    }

    public boolean isRepairInputXml() {
        return Utilities.stringToBoolean(this.properties.getProperty(REPAIR_INPUT_XML_KEY));
    }

    public String[] getPlaceKeys() {
        return this.placeKeys;
    }

    public Collection<ContentPermission> getPermissionRoles() {
        return this.permissionRoles;
    }

    public boolean isDeleteOutputCollection() {
        return Utilities.stringToBoolean(this.properties.getProperty(DELETE_COLLECTION_KEY, "false"));
    }

    public Session newOutputSession() {
        return this.newOutputSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session newOutputSession(String forestId) {
        if (null == this.outputConnection) {
            return null;
        }
        Connection[] connectionArray = this.outputConnection;
        synchronized (this.outputConnection) {
            int x = this.outputConnectionCount++ % this.outputConnection.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return forestId == null ? (Session)this.outputConnection[x].newSession() : (Session)this.outputConnection[x].newSession(forestId);
        }
    }

    public Map<String, BigInteger> getOutputForestMap() {
        Session sess;
        if (this.forestMap == null && (sess = this.newOutputSession()) != null) {
            try {
                this.forestMap = sess.getForestMap();
            }
            catch (XccException e) {
                logger.warning("can't get forest map");
            }
            sess.close();
        }
        return this.forestMap;
    }

    public String[] getOutputForestNames() {
        Map<String, BigInteger> fmap = this.getOutputForestMap();
        return fmap.keySet().toArray(new String[0]);
    }

    public String getOutputPackagePath() {
        return this.outputPackagePath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    private static void ensureFileExists(File outputFile) throws IOException {
        outputFile.mkdirs();
        if (!outputFile.exists()) {
            throw new IOException("path does not exist and could not be created: " + outputFile.getCanonicalPath());
        }
        if (!outputFile.canRead()) {
            throw new IOException("path cannot be read: " + outputFile.getCanonicalPath());
        }
        if (!outputFile.canWrite()) {
            throw new IOException("path is not writable: " + outputFile.getCanonicalPath());
        }
    }

    public int getThreadCount() {
        return Integer.parseInt(this.properties.getProperty(THREADS_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session newInputSession() {
        logger.fine(null == this.inputConnection ? null : this.inputConnection.toString());
        if (null == this.inputConnection) {
            return null;
        }
        Connection connection = this.inputConnection;
        synchronized (connection) {
            return (Session)this.inputConnection.newSession();
        }
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getInputPackagePath() {
        return this.inputPackagePath;
    }

    public Long getStartPosition() {
        return this.startPosition;
    }

    private String[] getDelimitedPropertyValues(String key, String pattern) {
        String property = this.properties.getProperty(key);
        logger.fine(key + "=" + property + " using " + pattern);
        if (null == property) {
            return null;
        }
        return property.split(pattern);
    }

    public String getConfigurationClassName() {
        return this.properties.getProperty(CONFIGURATION_CLASSNAME_KEY, CONFIGURATION_CLASSNAME_DEFAULT);
    }

    private String[] getDelimitedPropertyValues(String key) {
        return this.getDelimitedPropertyValues(key, "\\s+");
    }

    public String[] getInputCollectionUris() {
        return this.getDelimitedPropertyValues(INPUT_COLLECTION_URI_KEY);
    }

    public String[] getInputDirectoryUris() {
        return this.getDelimitedPropertyValues(INPUT_DIRECTORY_URI_KEY);
    }

    public String[] getInputDocumentUris() {
        return this.getDelimitedPropertyValues(INPUT_DOCUMENT_URIS_KEY);
    }

    public String[] getInputQuery() {
        return this.getDelimitedPropertyValues(INPUT_QUERY_KEY, ";;+");
    }

    public boolean getInputIndented() {
        return Utilities.stringToBoolean(this.properties.getProperty(INPUT_INDENTED_KEY), true);
    }

    public boolean isSkipExisting() {
        return Utilities.stringToBoolean(this.properties.getProperty(SKIP_EXISTING_KEY));
    }

    public static String getPackageFileExtension() {
        return ".zip";
    }

    public String getUriPrefix() {
        return this.uriPrefix;
    }

    public String[] getOutputCollections() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this + " outputCollections = " + Utilities.join(this.outputCollections, ","));
        }
        return this.outputCollections;
    }

    public boolean hasOutputCollections() {
        return null != this.outputCollections && this.outputCollections.length > 0;
    }

    public boolean isAllowEmptyMetadata() {
        return Utilities.stringToBoolean(this.properties.getProperty(ALLOW_EMPTY_METADATA_KEY));
    }

    public BigInteger getTimestamp() {
        return this.timestamp;
    }

    public boolean isInputQueryCachable() {
        return Boolean.parseBoolean(this.properties.getProperty(INPUT_CACHABLE_KEY));
    }

    public int inputQueryBufferSize() {
        return Integer.parseInt(this.properties.getProperty(INPUT_QUERY_BUFFER_BYTES_KEY));
    }

    public int getQueueSize() {
        return Integer.parseInt(this.properties.getProperty(QUEUE_SIZE_KEY, "100000")) / this.getInputBatchSize();
    }

    public String[] getOutputFormatFilters() {
        return this.outputFormatFilters;
    }

    public String getInputModule() {
        return this.properties.getProperty(INPUT_MODULE_URI_KEY);
    }

    public int inputResultBufferSize() {
        return Integer.parseInt(this.properties.getProperty(INPUT_RESULT_BUFFER_SIZE_KEY));
    }

    public int getInputBatchSize() {
        return Integer.parseInt(this.properties.getProperty(INPUT_BATCH_SIZE_KEY));
    }

    public int getMaxRetries() {
        return Integer.parseInt(this.properties.getProperty(MAX_RETRIES_KEY));
    }

    public int getOutputBatchSize() {
        return Integer.parseInt(this.properties.getProperty(OUTPUT_BATCH_SIZE_KEY));
    }

    public boolean useMultiStmtTxn() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_MULTI_STMT_TXN_KEY));
    }

    public boolean encodeOutputUri() {
        return Boolean.parseBoolean(this.properties.getProperty(ENCODE_OUTPUT_URI_KEY));
    }

    public boolean useRandomOutputUri() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_RANDOM_OUTPUT_URI_KEY));
    }

    public boolean isOutputConnection() {
        return null != this.outputConnection;
    }

    public String getUriPrefixStrip() {
        return this.properties.getProperty(URI_PREFIX_STRIP_KEY);
    }

    public String getUriSuffixStrip() {
        return this.properties.getProperty(URI_SUFFIX_STRIP_KEY);
    }

    public String getUriSuffix() {
        return this.properties.getProperty(URI_SUFFIX_KEY);
    }

    public boolean isThrottled() {
        return this.throttledEventsPerSecond > 0.0 || this.throttledBytesPerSecond > 0;
    }

    public int getThrottledBytesPerSecond() {
        return this.throttledBytesPerSecond;
    }

    public double getThrottledEventsPerSecond() {
        return this.throttledEventsPerSecond;
    }

    public boolean useInMemoryUriQueue() {
        String p = this.properties.getProperty(USE_IN_MEMORY_URI_QUEUE_KEY, "false");
        return Boolean.parseBoolean(p);
    }

    public boolean useQueueFile() {
        return !this.useInMemoryUriQueue() && this.properties.getProperty(INPUT_CONNECTION_STRING_KEY) != null;
    }

    public String getTmpDir() {
        return this.properties.getProperty(TMP_DIR_KEY, TMP_DIR_DEFAULT);
    }

    public String getUriQueueFile() {
        return this.properties.getProperty(URI_QUEUE_FILE_KEY, URI_QUEUE_FILE_DEFAULT);
    }

    public boolean keepUriQueueFile() {
        String p = this.properties.getProperty(KEEP_URI_QUEUE_FILE_KEY, "false");
        return Boolean.parseBoolean(p);
    }

    public boolean doPrintCurrRate() {
        String p = this.properties.getProperty(PRINT_CURRENT_RATE_KEY, "false");
        return Boolean.parseBoolean(p);
    }

    public boolean useInForestEval() {
        String p = this.properties.getProperty(USE_IN_FOREST_EVAL_KEY, "false");
        return Boolean.parseBoolean(p);
    }

    public boolean useChecksumModule() {
        String m = this.getChecksumModule();
        return m != null && !m.isEmpty();
    }

    public String getChecksumModule() {
        return this.properties.getProperty(CHECKSUM_MODULE_KEY);
    }

    public void close() {
        logger.fine("closed");
    }

    public WriterInterface newWriter() throws SyncException {
        if (this.isOutputConnection()) {
            return new SessionWriter(this);
        }
        return new FilePathWriter(this);
    }

    public ReaderInterface newReader() throws SyncException {
        return new SessionReader(this);
    }

    private void getPermissionRole(String propertyKey, ContentCapability capability) {
        String rolesString = this.properties.getProperty(propertyKey);
        if (rolesString != null) {
            String[] roleNames;
            for (String roleName : roleNames = rolesString.split(CSV_SCSV_SSV_REGEX)) {
                this.permissionRoles.add(new ContentPermission(capability, roleName));
            }
        }
    }
}

