/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.xqsync.AbstractReader;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.DocumentInterface;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.XQSyncDocument;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;

public class FilePathReader
extends AbstractReader {
    protected final boolean allowEmptyMetadata;

    public FilePathReader(Configuration configuration) throws SyncException {
        super(configuration);
        this.allowEmptyMetadata = configuration.isAllowEmptyMetadata();
    }

    @Override
    public void read(String[] uris, DocumentInterface document) throws SyncException {
        try {
            for (int i = 0; i < uris.length; ++i) {
                String uri = uris[i];
                if (uri == null) {
                    throw new SyncException("null path " + i);
                }
                File file = new File(uri);
                document.setContent(i, new FileInputStream(file));
                File metaFile = XQSyncDocument.getMetadataFile(file);
                if (!metaFile.exists()) {
                    if (this.allowEmptyMetadata) {
                        XQSyncDocumentMetadata metadata = new XQSyncDocumentMetadata();
                        document.setMetadata(i, metadata);
                    } else {
                        throw new SyncException("no metadata for " + uri);
                    }
                }
                document.setMetadata(i, new FileReader(metaFile));
            }
        }
        catch (IOException e) {
            throw new SyncException(e);
        }
    }
}

