/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.xqsync.AbstractWriter;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.XQSyncDocument;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FilePathWriter
extends AbstractWriter {
    protected final String root;

    public FilePathWriter(Configuration configuration) {
        super(configuration);
        this.root = configuration.getOutputPath();
    }

    @Override
    public int write(String uri, byte[] bytes, XQSyncDocumentMetadata metadata) throws SyncException {
        try {
            File outputFile = new File(this.root, uri);
            this.write(bytes, outputFile);
            int metaBytesLength = this.writeMetadataFile(metadata, outputFile);
            return bytes.length + metaBytesLength;
        }
        catch (IOException e) {
            throw new SyncException(e);
        }
    }

    protected int writeMetadataFile(XQSyncDocumentMetadata metadata, File outputFile) throws IOException, SyncException {
        String metadataFilePath = XQSyncDocument.getMetadataPath(outputFile);
        byte[] metaBytes = metadata.toXML().getBytes();
        this.write(metaBytes, metadataFilePath);
        return metaBytes.length;
    }

    protected void write(byte[] bytes, String filePath) throws IOException, SyncException {
        File file = new File(filePath);
        this.write(bytes, file);
    }

    protected void write(byte[] bytes, File outputFile) throws IOException, SyncException {
        File parent = outputFile.getParentFile();
        if (null == parent) {
            throw new FatalException("no parent for " + outputFile.getCanonicalPath());
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!parent.isDirectory()) {
            throw new SyncException("parent is not a directory: " + parent.getCanonicalPath());
        }
        if (!parent.canWrite()) {
            throw new SyncException("cannot write to parent directory: " + parent.getCanonicalPath());
        }
        try (FileOutputStream mfos = new FileOutputStream(outputFile);){
            mfos.write(bytes);
            mfos.flush();
        }
    }
}

