/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FragmentZipFiles {
    private static final SimpleLogger logger = SimpleLogger.getSimpleLogger();

    public static void main(String[] args) throws Exception {
        String encoding = System.getProperty("file.encoding");
        if (!StandardCharsets.UTF_8.name().equals(encoding)) {
            throw new UTFDataFormatException("system encoding " + encoding + "is not UTF-8");
        }
        logger.configureLogger(System.getProperties());
        int threads = Integer.parseInt(System.getProperty("THREADS", "" + Runtime.getRuntime().availableProcessors()));
        int capacity = 1000 * threads;
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(capacity);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, workQueue);
        threadPoolExecutor.prestartAllCoreThreads();
        for (String arg : args) {
            File file = new File(arg);
            FragmentTask task = new FragmentTask(file);
            threadPoolExecutor.submit(task);
        }
        threadPoolExecutor.shutdown();
        while (!threadPoolExecutor.isTerminated()) {
            threadPoolExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        logger.info("all files completed");
    }

    static class FragmentTask
    implements Runnable {
        private static final String ZIP_EXTENSION = ".zip";
        final File file;

        public FragmentTask(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                String path = this.file.getCanonicalPath();
                if (!this.file.getName().endsWith(ZIP_EXTENSION)) {
                    logger.info("skipping non-zip file " + path);
                    return;
                }
                this.fragment(path);
            }
            catch (Throwable t) {
                logger.logException("fatal error", t);
            }
        }

        private void fragment(String path) throws IOException {
            logger.info("fragmenting path" + path);
            File parent = this.file.getParentFile();
            String basename = path.substring(0, path.length() - ZIP_EXTENSION.length());
            String delimiter = "-";
            int fileIndex = 0;
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.file));){
                ZipEntry srcEntry;
                DeflaterOutputStream output = null;
                long entries = 0L;
                String lastEntryName = null;
                logger.fine("looking for entries in " + path);
                while ((srcEntry = zis.getNextEntry()) != null) {
                    String thisEntryName = srcEntry.getName();
                    logger.finer("looking at entry " + thisEntryName + " in " + path);
                    logger.finer("output " + output + ", entries=" + ++entries);
                    if (null == output || entries >= 65534L) {
                        logger.fine("new output needed");
                        if (this.areRelated(lastEntryName, thisEntryName)) {
                            logger.info("keeping content and metadata together for " + lastEntryName);
                        } else {
                            logger.fine("new output will be created");
                            if (null != output) {
                                output.flush();
                                ((ZipOutputStream)output).close();
                            }
                            entries = 0L;
                            output = this.nextOutput(basename, delimiter, fileIndex++, parent);
                        }
                    }
                    logger.finest("remembering entry " + thisEntryName);
                    lastEntryName = thisEntryName;
                    long size = srcEntry.getSize();
                    long compressedSize = srcEntry.getCompressedSize();
                    logger.finer("duplicating entry " + thisEntryName + " in " + path + ": " + size + "; " + compressedSize);
                    ZipEntry dstEntry = new ZipEntry(srcEntry);
                    dstEntry.setCompressedSize(-1L);
                    ((ZipOutputStream)output).putNextEntry(dstEntry);
                    if (!srcEntry.isDirectory()) {
                        long bytes = Utilities.copy(zis, (OutputStream)output);
                        logger.finer("copied " + thisEntryName + ": " + bytes + " Bytes");
                    }
                    ((ZipOutputStream)output).closeEntry();
                    output.flush();
                    logger.fine("processed entry " + entries + ": " + lastEntryName);
                }
                if (null != output) {
                    output.flush();
                    ((ZipOutputStream)output).close();
                }
            }
            logger.info("fragmented " + path);
        }

        private boolean areRelated(String lastName, String thisName) {
            return !(lastName == null || thisName == null || !lastName.endsWith(".metadata") && !thisName.endsWith(".metadata") || !lastName.startsWith(thisName) && !thisName.startsWith(lastName));
        }

        private ZipOutputStream nextOutput(String basename, String delimiter, int fileIndex, File parent) throws IOException {
            String nextName = this.nextName(basename, delimiter, fileIndex++);
            File outFile = new File(parent, nextName);
            logger.info("opening new zip file: " + outFile.getCanonicalPath());
            return new ZipOutputStream(new FileOutputStream(outFile));
        }

        private String nextName(String basename, String delimiter, int i) {
            return basename + delimiter + String.format("%04d", i) + ZIP_EXTENSION;
        }
    }
}

