/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.Utilities;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.XQSyncDocument;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class InputPackage {
    protected SimpleLogger logger;
    protected Configuration configuration;
    protected static final int MAX_ENTRIES = 65535;
    protected String packagePath;
    protected ZipFile inputZip;
    protected final File inputFile;
    protected volatile int references = 0;
    protected boolean allowEmptyMetadata;
    protected final Object referenceMutex = new Object();

    public InputPackage(String path, Configuration config) throws IOException {
        this.inputFile = new File(path);
        this.inputZip = new ZipFile(this.inputFile);
        this.packagePath = this.inputFile.getCanonicalPath();
        this.configuration = config;
        this.logger = this.configuration.getLogger();
        this.allowEmptyMetadata = this.configuration.isAllowEmptyMetadata();
    }

    public String getPath() {
        return this.packagePath;
    }

    public XQSyncDocumentMetadata getMetadataEntry(String path) throws IOException {
        InputStream entryStream = this.getEntryStream(XQSyncDocument.getMetadataPath(path));
        if (this.allowEmptyMetadata && null == entryStream) {
            return new XQSyncDocumentMetadata();
        }
        return XQSyncDocumentMetadata.fromXML(new InputStreamReader(entryStream));
    }

    private InputStream getEntryStream(String path) throws IOException {
        ZipEntry entry = this.inputZip.getEntry(path);
        if (null != entry) {
            return this.inputZip.getInputStream(entry);
        }
        int size = this.inputZip.size();
        if (size >= 65535) {
            this.logger.warning("too many entries in input-package: " + size + " >= " + 65535 + " (" + path + ")");
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.inputFile));){
                while ((entry = zis.getNextEntry()) != null && !entry.getName().equals(path)) {
                }
                ZipInputStream zipInputStream = zis;
                return zipInputStream;
            }
        }
        if (this.allowEmptyMetadata && path.endsWith(".metadata")) {
            return null;
        }
        throw new IOException("entry " + path + " not found in " + this.inputZip.getName());
    }

    public byte[] getContent(String path) throws IOException {
        return Utilities.cat(this.getEntryStream(path));
    }

    public List<String> list() throws IOException {
        if (null == this.inputZip) {
            throw new NullPointerException("no input zip file");
        }
        int size = this.inputZip.size();
        this.logger.fine("expecting " + size + " entries");
        if (0 == size) {
            this.logger.warning("0 entries found in " + this.packagePath);
        }
        long entries = 0L;
        HashSet<String> documentList = new HashSet<String>();
        if (size < 65535) {
            Enumeration<? extends ZipEntry> e = this.inputZip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                entries += (long)this.addEntry(entry, documentList);
            }
        } else {
            this.logger.warning("too many entries in input-package: " + size + " >= " + 65535);
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(this.inputFile));){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    entries += (long)this.addEntry(entry, documentList);
                }
            }
        }
        this.logger.fine("listed " + documentList.size() + " documents from " + entries + " entries");
        return new LinkedList<String>(documentList);
    }

    private int addEntry(ZipEntry entry, HashSet<String> documentList) {
        if (entry.isDirectory() && entry.getSize() == 0L) {
            this.logger.warning("skipping zero-length directory " + entry.getName());
            return 0;
        }
        String path = entry.getName();
        this.logger.finest("found " + path);
        if (path.endsWith(".metadata")) {
            path = path.substring(0, path.length() - ".metadata".length());
        }
        if (documentList.contains(path)) {
            return 0;
        }
        documentList.add(path);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference() {
        Object object = this.referenceMutex;
        synchronized (object) {
            ++this.references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReference() {
        Object object = this.referenceMutex;
        synchronized (object) {
            --this.references;
            if (0 > this.references) {
                throw new FatalException("bad reference count for " + this.inputZip.getName() + " : " + this.references);
            }
            if (0 != this.references) {
                return;
            }
            this.logger.fine("closing " + this.inputZip.getName() + " (" + this.references + ")");
            try {
                this.inputZip.close();
            }
            catch (IOException e) {
                this.logger.logException(this.inputZip.getName(), e);
            }
        }
    }

    public int size() {
        return this.inputZip.size();
    }
}

