/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.XQSyncDocument;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class OutputPackage {
    protected static SimpleLogger logger;
    protected final Configuration configuration;
    static final int MAX_ENTRIES = 65534;
    public static final String EXTENSION = ".zip";
    private long currentFileBytes = 0L;
    private final Object outputMutex = new Object();
    private ZipOutputStream outputStream;
    private static final Object closeMutex;
    private final File constructorFile;
    private File currentFile;
    private int fileCount = 0;
    private int currentEntries;

    public OutputPackage(File file, Configuration config) {
        this.constructorFile = file;
        this.configuration = config;
        logger = config.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.outputMutex;
        synchronized (object) {
            if (null == this.outputStream) {
                return;
            }
            new CloseThread(this.outputStream, this.currentFile.getName()).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(String outputPath, byte[] bytes, XQSyncDocumentMetadata metadata) throws IOException {
        if (null == outputPath) {
            throw new NullPointerException("null path");
        }
        if (null == bytes) {
            throw new NullPointerException("null content bytes");
        }
        if (null == metadata) {
            throw new NullPointerException("null metadata");
        }
        byte[] metaBytes = metadata.toXML().getBytes();
        long total = bytes.length + metaBytes.length;
        ZipEntry entry = new ZipEntry(outputPath);
        String metadataPath = XQSyncDocument.getMetadataPath(outputPath);
        ZipEntry metaEntry = new ZipEntry(metadataPath);
        Object object = this.outputMutex;
        synchronized (object) {
            if (this.outputStream == null) {
                logger.fine("no existing package");
                this.newOutputStream();
            }
            if (this.currentFileBytes > 0L && this.currentFileBytes + total > Integer.MAX_VALUE) {
                logger.fine("too many bytes in current package");
                this.newOutputStream();
            }
            if (this.currentEntries > 0 && this.currentEntries + 2 >= 65534) {
                logger.fine("too many entries in current package");
                this.newOutputStream();
            }
            try {
                this.outputStream.putNextEntry(entry);
                this.outputStream.write(bytes);
                this.outputStream.closeEntry();
                this.outputStream.putNextEntry(metaEntry);
                this.outputStream.write(metaBytes);
                this.outputStream.closeEntry();
            }
            catch (ZipException e) {
                if (this.configuration.isSkipExisting() && e.getMessage().startsWith("duplicate entry")) {
                    logger.warning("skipping duplicate entry: " + entry.getName());
                    return 0L;
                }
                throw e;
            }
        }
        this.currentFileBytes += total;
        this.currentEntries += 2;
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newOutputStream() throws IOException {
        String canonicalPath;
        String path = canonicalPath = this.constructorFile.getCanonicalPath();
        Object object = this.outputMutex;
        synchronized (object) {
            if (this.fileCount > 0) {
                path = OutputPackage.newPackagePath(canonicalPath, this.fileCount, 6);
            }
            this.close();
            logger.info("new output package " + path);
            this.currentFileBytes = 0L;
            this.currentEntries = 0;
            this.currentFile = new File(path);
            this.outputStream = new ZipOutputStream(new FileOutputStream(this.currentFile));
            ++this.fileCount;
        }
    }

    protected static String newPackagePath(String canonicalPath, int count, int width) {
        String path = canonicalPath;
        if (path.endsWith(EXTENSION)) {
            String pathPattern = "(.+).zip$";
            String replacementPattern = "$1-" + String.format("%0" + width + "d", count) + EXTENSION;
            path = path.replaceFirst(pathPattern, replacementPattern);
        } else {
            path = path + "-" + count;
        }
        assert (path.equals(canonicalPath));
        return path;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    static {
        closeMutex = new Object();
    }

    static class CloseThread
    extends Thread {
        private final ZipOutputStream zos;
        private final String name;

        public CloseThread(ZipOutputStream zos, String name) {
            this.zos = zos;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = closeMutex;
                synchronized (object) {
                    this.zos.flush();
                    this.zos.close();
                }
                logger.info("saved " + this.name);
            }
            catch (IOException e) {
                throw new FatalException(e);
            }
        }
    }
}

