/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.DocumentInterface;
import com.marklogic.ps.xqsync.FilePathReader;
import com.marklogic.ps.xqsync.InputPackage;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.IOException;

public class PackageReader
extends FilePathReader {
    protected InputPackage pkg;

    public PackageReader(Configuration configuration) throws SyncException {
        super(configuration);
    }

    public void setPackage(InputPackage pkg) {
        this.pkg = pkg;
    }

    @Override
    public void read(String[] uris, DocumentInterface document) throws SyncException {
        if (null == uris) {
            throw new SyncException("null paths");
        }
        if (null == uris[0]) {
            throw new SyncException("empty paths");
        }
        if (null == this.pkg) {
            throw new SyncException("null input package");
        }
        for (int i = 0; i < uris.length; ++i) {
            String uri = uris[i];
            if (uri == null) continue;
            try {
                document.setContent(i, this.pkg.getContent(uri));
                XQSyncDocumentMetadata metadata = this.pkg.getMetadataEntry(uri);
                document.setMetadata(i, metadata);
                continue;
            }
            catch (IOException e) {
                throw new SyncException(e);
            }
        }
    }

    public String getPath() {
        return this.pkg.getPath();
    }

    @Override
    public void close() {
        this.pkg.closeReference();
        super.close();
    }
}

