/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.InputPackage;
import com.marklogic.ps.xqsync.PackageReader;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.XQSyncDocument;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PackageValidator {
    static SimpleLogger logger;
    static Collection<String> pathsObserved;
    static Map<String, String> urisObserved;
    private static Configuration config;
    private static PackageReader reader;

    public static void main(String[] args) throws Exception {
        logger = SimpleLogger.getSimpleLogger();
        PackageValidator.validatePaths(args);
    }

    private static void validatePaths(String[] args) throws SyncException {
        pathsObserved = new HashSet<String>();
        urisObserved = new HashMap<String, String>();
        config = new Configuration();
        config.setLogger(logger);
        reader = new PackageReader(config);
        long count = 0L;
        for (String arg : args) {
            File file = new File(arg);
            if (!file.exists()) {
                logger.warning("file does not exist, skipping " + arg);
                continue;
            }
            if (!file.canRead()) {
                logger.warning("cannot read file, skipping " + arg);
                continue;
            }
            if (file.isDirectory()) {
                logger.warning("skipping directory " + arg);
                continue;
            }
            try {
                count += (long)PackageValidator.validate(file);
            }
            catch (Exception e) {
                logger.logException(arg, e);
            }
        }
        logger.info("checked " + count + " uris");
    }

    private static int validate(File file) throws IOException, SyncException {
        String canonicalPath = file.getCanonicalPath();
        logger.fine(canonicalPath);
        if (pathsObserved.contains(canonicalPath)) {
            logger.warning("skipping duplicate package " + canonicalPath);
            return 0;
        }
        pathsObserved.add(canonicalPath);
        InputPackage pkg = new InputPackage(canonicalPath, config);
        reader.setPackage(pkg);
        Iterator<String> iter = pkg.list().iterator();
        int count = 0;
        if (!iter.hasNext()) {
            logger.warning("no uris found in " + canonicalPath);
            return 0;
        }
        while (iter.hasNext()) {
            String uri = iter.next();
            if (urisObserved.containsKey(uri)) {
                logger.warning("duplicate uri in " + canonicalPath + " from " + urisObserved.get(uri) + ": " + uri);
            } else {
                urisObserved.put(uri, canonicalPath);
            }
            XQSyncDocument doc = new XQSyncDocument(new String[]{uri}, reader, null, config);
            doc.read();
            ++count;
        }
        logger.info(canonicalPath + ": " + count + " ok");
        return count;
    }
}

