/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.xqsync.AbstractWriter;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.OutputPackage;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.Closeable;
import java.io.IOException;

public class PackageWriter
extends AbstractWriter
implements Closeable {
    final OutputPackage pkg;

    public PackageWriter(Configuration configuration, OutputPackage pkg) {
        super(configuration);
        this.pkg = pkg;
    }

    @Override
    public int write(String uri, byte[] bytes, XQSyncDocumentMetadata metadata) throws SyncException {
        if (null == this.pkg) {
            throw new SyncException("null output package");
        }
        if (null == bytes) {
            throw new SyncException("null output bytes");
        }
        if (null == metadata) {
            throw new SyncException("null output metadata");
        }
        try {
            return (int)this.pkg.write(uri, bytes, metadata);
        }
        catch (IOException e) {
            throw new SyncException(e);
        }
    }

    @Override
    public void close() {
        if (null != this.pkg) {
            this.pkg.close();
        }
    }
}

