/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.Session;
import com.marklogic.ps.Utilities;
import com.marklogic.ps.xqsync.AbstractReader;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.DocumentInterface;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.MetadataInterface;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.XQueryException;
import com.marklogic.xcc.exceptions.XccException;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XSInteger;
import com.marklogic.xcc.types.XdmElement;
import java.io.IOException;
import java.math.BigInteger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader
extends AbstractReader {
    protected static volatile String query = null;
    private final BigInteger timestamp;
    private final String inputModule;
    protected final boolean copyPermissions;
    protected final boolean copyProperties;
    protected final boolean copyCollections;
    protected final boolean copyQuality;
    protected final boolean isIndented;
    protected int size = 1;

    public SessionReader(Configuration configuration) throws SyncException {
        super(configuration);
        this.copyPermissions = configuration.isCopyPermissions();
        this.copyProperties = configuration.isCopyProperties();
        this.copyCollections = configuration.isCopyCollections();
        this.copyQuality = configuration.isCopyQuality();
        this.isIndented = configuration.getInputIndented();
        this.timestamp = configuration.getTimestamp();
        this.inputModule = configuration.getInputModule();
        this.size = configuration.getInputBatchSize();
        if (null == query) {
            this.initQuery();
            this.logger.fine("reader query = \n" + query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String[] uris, DocumentInterface document) throws SyncException {
        block19: {
            if (null == uris) {
                throw new SyncException("null uris");
            }
            if (uris.length != this.size) {
                throw new SyncException("bad uris, " + uris.length + " != " + this.size);
            }
            if (null == document) {
                throw new SyncException("null document");
            }
            ResultSequence rs = null;
            Session session = null;
            int urisIndex = 0;
            try {
                int retries = 3;
                while (retries > 0) {
                    String urisJoined;
                    urisIndex = 0;
                    try {
                        session = this.configuration.newInputSession();
                        if (null == session) {
                            throw new FatalException("null input session");
                        }
                        RequestOptions opts = session.getDefaultRequestOptions();
                        if (null != this.timestamp) {
                            opts.setEffectivePointInTime(this.timestamp);
                        }
                        opts.setResultBufferSize(this.configuration.inputResultBufferSize());
                        AdhocQuery req = session.newAdhocQuery(query, opts);
                        for (int i = 0; i < uris.length; ++i) {
                            req.setNewStringVariable("URI-" + i, null != uris[i] ? uris[i] : "");
                        }
                        req.setNewStringVariable("MODULE-URI", null == this.inputModule ? "" : this.inputModule);
                        if (this.configuration.useChecksumModule()) {
                            req.setNewStringVariable("CHECKSUM-MODULE", this.configuration.getChecksumModule());
                        }
                        rs = session.submitRequest((Request)req);
                        break;
                    }
                    catch (XQueryException e) {
                        urisJoined = Utilities.join(uris, "; ");
                        this.logger.severe("error in document, uri = " + urisJoined);
                        this.logger.severe("error in query: " + query);
                        throw new SyncException(urisJoined, e);
                    }
                    catch (XccException e) {
                        urisJoined = Utilities.join(uris, "; ");
                        if (--retries < 1) {
                            this.logger.severe("retries exhausted for " + urisJoined);
                            throw new SyncException(urisJoined, e);
                        }
                        this.logger.warning("error reading document: will retry (" + retries + "): " + urisJoined + " due to " + e.getMessage());
                        Thread.yield();
                        if (null != session && !session.isClosed()) {
                            session.close();
                        }
                        session = this.configuration.newInputSession();
                    }
                }
                if (rs == null) break block19;
                if (!rs.hasNext()) {
                    throw new SyncException("unexpected empty document: " + uris[urisIndex]);
                }
                ResultItem[] items = rs.toResultItemArray();
                int resultIndex = 0;
                while (resultIndex < items.length) {
                    this.logger.fine("resultIndex " + resultIndex + "/" + items.length);
                    if (null == uris[urisIndex]) {
                        this.logger.fine("uri at " + urisIndex + " is null");
                        break;
                    }
                    this.logger.fine("reading uri: " + uris[urisIndex]);
                    resultIndex = this.readDocument(document, items, urisIndex, resultIndex);
                    ++urisIndex;
                }
            }
            finally {
                this.cleanup(session, rs);
            }
        }
    }

    private int readDocument(DocumentInterface document, ResultItem[] items, int urisIndex, int resultIndex) throws SyncException {
        MetadataInterface metadata = document.newMetadata();
        String format = items[resultIndex].asString();
        this.logger.finer("format = " + format);
        metadata.setFormat(format);
        ++resultIndex;
        while (resultIndex < items.length && items[resultIndex].getItemType() == ValueType.XS_STRING) {
            if (!this.copyCollections) {
                ++resultIndex;
                continue;
            }
            metadata.addCollection(items[resultIndex].asString());
            ++resultIndex;
        }
        while (resultIndex < items.length && ValueType.ELEMENT == items[resultIndex].getItemType()) {
            if (!this.copyPermissions) {
                ++resultIndex;
                continue;
            }
            this.readPermission((XdmElement)items[resultIndex].getItem(), metadata);
            ++resultIndex;
        }
        metadata.setQuality((XSInteger)items[resultIndex].getItem());
        ++resultIndex;
        if (metadata.isBinary()) {
            document.setContent(urisIndex, items[resultIndex].asInputStream());
        } else {
            document.setContent(urisIndex, items[resultIndex].asReader());
        }
        if (this.copyProperties && ValueType.ELEMENT == items[++resultIndex].getItemType()) {
            String pString = items[resultIndex].asString();
            if (pString != null) {
                metadata.setProperties(pString);
            }
            ++resultIndex;
        }
        if (this.configuration.useChecksumModule()) {
            String hashValue = items[resultIndex].asString();
            metadata.setHashValue(hashValue);
            this.logger.fine("hashValue = " + hashValue);
            ++resultIndex;
        }
        if (ValueType.XS_INTEGER != items[resultIndex].getItemType()) {
            throw new SyncException("unexpected " + items[resultIndex].getItemType() + " " + items[resultIndex].asString() + ", expected " + ValueType.XS_INTEGER + " 0");
        }
        document.setMetadata(urisIndex, metadata);
        return ++resultIndex;
    }

    protected void cleanup(Session session, ResultSequence rs) {
        if (null != rs && !rs.isClosed()) {
            rs.close();
        }
        if (null != session && !session.isClosed()) {
            session.close();
        }
    }

    private void readPermission(XdmElement permissionElement, MetadataInterface metadata) throws SyncException {
        this.logger.fine("permissionElement = " + permissionElement.asString());
        try {
            Element permissionW3cElement = permissionElement.asW3cElement();
            this.logger.fine("permissionElement = " + permissionW3cElement.toString());
            NodeList capabilities = permissionW3cElement.getElementsByTagName("sec:capability");
            NodeList roles = permissionW3cElement.getElementsByTagName("sec:role-name");
            if (0 < roles.getLength() && 0 < capabilities.getLength()) {
                Node role = roles.item(0);
                Node capability = capabilities.item(0);
                metadata.addPermission(capability.getTextContent(), role.getTextContent());
                if (roles.getLength() > 1) {
                    this.logger.warning("input permission: " + permissionW3cElement + ": " + roles.getLength() + " roles, using only 1");
                }
                if (capabilities.getLength() > 1) {
                    this.logger.warning("input permission: " + permissionW3cElement + ": " + capabilities.getLength() + " capabilities, using only 1");
                }
            } else {
                if (roles.getLength() < 1) {
                    this.logger.warning("skipping input permission: " + permissionW3cElement + ": no roles");
                }
                if (capabilities.getLength() < 1) {
                    this.logger.warning("skipping input permission: " + permissionW3cElement + ": no capabilities");
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SyncException(e);
        }
    }

    private synchronized void initQuery() {
        int i;
        if (null != query) {
            return;
        }
        if (null != this.inputModule) {
            this.logger.info("using INPUT_MODULE_URI=" + this.inputModule);
        }
        StringBuilder localQuery = new StringBuilder("xquery version \"1.0-ml\";\n");
        if (!this.isIndented) {
            localQuery.append("declare boundary-space preserve;\n");
            localQuery.append("declare option xdmp:output \"indent=no\";\n");
        }
        if (this.configuration.useChecksumModule()) {
            localQuery.append("declare variable $CHECKSUM-MODULE as xs:string external;\n");
        }
        localQuery.append("declare variable $MODULE-URI as xs:string external;\n");
        String predicate = this.configuration.isRepairMultipleDocumentsPerUri() ? "[1]" : "";
        for (i = 0; i < this.size; ++i) {
            localQuery.append("declare variable $URI-").append(i).append(" as xs:string external;\n").append("declare variable $DOC-").append(i).append(" as document-node() := \n").append("  if ($URI-").append(i).append(" eq '') then document { () }\n").append("  else if ($MODULE-URI) then xdmp:invoke(\n").append("    $MODULE-URI, (xs:QName('URI'), $URI-").append(i).append("))").append(predicate).append("\n").append("  else doc($URI-").append(i).append(")").append(predicate).append("\n").append(";\n").append("declare variable $ROOT-").append(i).append(" as node()? := \n").append(" (\n").append("  $DOC-").append(i).append("/element(), $DOC-").append(i).append("/binary(), $DOC-").append(i).append("/comment(),\n").append("  $DOC-").append(i).append("/processing-instruction(), $DOC-").append(i).append("/text()\n").append(" )[1] ;\n");
        }
        for (i = 0; i < this.size; ++i) {
            localQuery.append(0 == i ? "\n" : ",\n");
            localQuery.append("if ($ROOT-").append(i).append(") then xdmp:node-kind($ROOT-").append(i).append(") else 'text',\n");
            if (this.copyCollections) {
                localQuery.append("if ($URI-").append(i).append(" eq '') then ()\n").append("else xdmp:document-get-collections($URI-").append(i).append("),\n");
            }
            if (this.copyPermissions) {
                localQuery.append("let $list := \n  if ($URI-").append(i).append(" eq '') then ()\n").append("else xdmp:document-get-permissions($URI-").append(i).append(")\n").append("let $query := concat(\n").append("' import module ''http://marklogic.com/xdmp/security''").append(" at ''/MarkLogic/security.xqy'';',\n").append("' declare variable $LIST as element(sec:permissions) external;',\n").append("' for $p in $LIST/sec:permission',\n").append("' return element sec:permission {',\n").append("'  $p/@*, $p/node(), sec:get-role-names($p/sec:role-id)',\n").append("' }'\n").append(")\n").append("where exists($list)\n").append("return xdmp:eval(\n").append("  $query,\n").append("  (xs:QName('LIST'),\n").append("   element sec:permissions { $list }),\n").append("  <options xmlns=\"xdmp:eval\">\n").append("    <database>{ xdmp:security-database() }</database>\n").append("  </options> ),\n");
            }
            if (this.copyQuality) {
                localQuery.append("if ($URI-").append(i).append(" eq '') then 0\n").append("else xdmp:document-get-quality($URI-").append(i).append("),\n");
            } else {
                localQuery.append("0,");
            }
            localQuery.append("$DOC-").append(i).append(",\n");
            if (this.copyProperties) {
                localQuery.append("if ($URI-").append(i).append(" eq '') then ()\n").append("else xdmp:document-properties($URI-").append(i).append(")/prop:properties,\n");
            } else {
                localQuery.append("(),\n");
            }
            if (this.configuration.useChecksumModule()) {
                localQuery.append("if ($URI-").append(i).append(" eq '') then ()\n").append("else xdmp:invoke($CHECKSUM-MODULE, (xs:QName('URI'), $URI-").append(i).append(")),\n");
            } else {
                localQuery.append("(),\n");
            }
            localQuery.append("0\n");
        }
        query = localQuery.toString();
    }
}

