/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.Session;
import com.marklogic.ps.Utilities;
import com.marklogic.ps.xqsync.AbstractWriter;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.MetadataInterface;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.DocumentRepairLevel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.XccException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class SessionWriter
extends AbstractWriter {
    protected static Object firstMaxTasksMutex = new Object();
    protected static boolean firstMaxTasks = false;
    protected Map<String, BigInteger> forestMap = null;
    protected String[] forestNameArray = null;
    protected int lastBatchSize = -1;
    protected String query = null;
    protected int maxRetries = 3;

    public SessionWriter(Configuration configuration) throws SyncException {
        super(configuration);
        if (configuration.useInForestEval()) {
            this.forestMap = configuration.getOutputForestMap();
            if (this.forestMap == null) {
                throw new SyncException("cannot retrieve forest map");
            }
            this.forestNameArray = this.placeKeys;
            if (this.forestNameArray == null || this.forestNameArray.length == 0) {
                this.forestNameArray = configuration.getOutputForestNames();
            }
        }
        this.maxRetries = configuration.getMaxRetries();
    }

    @Override
    public int write(String outputUri, byte[] contentBytes, XQSyncDocumentMetadata metadata) throws SyncException {
        String[] outputUriArray = new String[1];
        byte[][] contentBytesArray = new byte[1][0];
        XQSyncDocumentMetadata[] metadataArray = new XQSyncDocumentMetadata[1];
        outputUriArray[0] = outputUri;
        contentBytesArray[0] = contentBytes;
        metadataArray[0] = metadata;
        return this.write(outputUriArray, contentBytesArray, metadataArray);
    }

    @Override
    public int write(String[] outputUri, byte[][] contentBytes, XQSyncDocumentMetadata[] metadata) throws SyncException {
        int i;
        int bytes = 0;
        boolean useInForestEval = this.configuration.useInForestEval();
        if (null == outputUri || outputUri.length == 0) {
            return bytes;
        }
        boolean[] ignoreList = new boolean[outputUri.length];
        for (i = 0; i < outputUri.length; ++i) {
            ignoreList[i] = this.matchesFilters(outputUri[i], metadata[i]);
        }
        for (i = 0; i < outputUri.length; ++i) {
            if (ignoreList[i] || null != outputUri[i] && !outputUri[i].isEmpty()) continue;
            ignoreList[i] = true;
        }
        String forestName = null;
        BigInteger forestIdBigInt = null;
        Session session = null;
        if (!useInForestEval) {
            session = this.configuration.newOutputSession();
        } else {
            int evalForestIdx = Math.abs(outputUri[0].hashCode() % this.forestNameArray.length);
            forestName = this.forestNameArray[evalForestIdx];
            forestIdBigInt = this.forestMap.get(forestName);
            if (null == forestIdBigInt) {
                throw new FatalException("forest " + forestName + " not found");
            }
            session = this.configuration.newOutputSession("#" + forestIdBigInt);
        }
        if (null == session) {
            throw new FatalException("null output session");
        }
        if (!useInForestEval) {
            int i2;
            for (i2 = 0; i2 < outputUri.length; ++i2) {
                if (ignoreList[i2] || null != contentBytes[i2] && contentBytes[i2].length >= 1) continue;
                ignoreList[i2] = true;
                try {
                    session.deleteDocument(outputUri[i2]);
                    continue;
                }
                catch (XccException e) {
                    this.logger.logException("error deleting document: " + outputUri[i2], e);
                }
            }
            if (this.skipExisting) {
                for (i2 = 0; i2 < outputUri.length; ++i2) {
                    if (ignoreList[i2]) continue;
                    try {
                        if (!session.existsDocument(outputUri[i2])) continue;
                        ignoreList[i2] = true;
                        continue;
                    }
                    catch (XccException e) {
                        this.logger.logException("error on check existing document: " + outputUri[i2], e);
                    }
                }
            }
        }
        ArrayList<Content> contentList = new ArrayList<Content>(outputUri.length);
        for (int i3 = 0; i3 < outputUri.length; ++i3) {
            if (ignoreList[i3]) continue;
            ContentCreateOptions options = null;
            if (metadata[i3].isBinary()) {
                this.logger.fine(outputUri[i3] + " is binary");
                options = ContentCreateOptions.newBinaryInstance();
            } else if (metadata[i3].isText()) {
                this.logger.fine(outputUri[i3] + " is text");
                options = ContentCreateOptions.newTextInstance();
            } else {
                this.logger.fine(outputUri[i3] + " is xml");
                options = ContentCreateOptions.newXmlInstance();
            }
            metadata[i3].addPermissions(this.permissionRoles);
            ContentPermission[] permissions = metadata[i3].getPermissions();
            if (permissions.length > 0) {
                options.setPermissions(permissions);
            }
            String[] collections = metadata[i3].getCollections();
            this.logger.fine("collections = " + Utilities.join(collections, " "));
            options.setCollections(collections);
            options.setQuality(metadata[i3].getQuality());
            options.setNamespace(null);
            DocumentRepairLevel repair = !this.repairInputXml ? DocumentRepairLevel.NONE : DocumentRepairLevel.FULL;
            this.logger.fine("repair = " + this.repairInputXml + ", " + repair);
            options.setRepairLevel(repair);
            if (null != this.placeKeys) {
                try {
                    if (forestIdBigInt == null) {
                        this.logger.finest("placeKeys = " + Utilities.join(this.placeKeys, ","));
                        options.setPlaceKeys(session.forestNamesToIds(this.placeKeys));
                    } else {
                        BigInteger[] forestIds = new BigInteger[]{forestIdBigInt};
                        options.setPlaceKeys(forestIds);
                    }
                }
                catch (XccException e) {
                    this.logger.logException("error on setting placekeys: " + outputUri[i3], e);
                }
            }
            Content content = ContentFactory.newContent((String)outputUri[i3], (byte[])contentBytes[i3], (ContentCreateOptions)options);
            contentList.add(content);
        }
        DocumentRepairLevel contentArray = contentList.toArray(new Content[0]);
        int retries = this.maxRetries;
        long sleepMillis = 250L;
        while (retries > 0) {
            try {
                if (this.configuration.useMultiStmtTxn()) {
                    session.setTransactionMode(Session.TransactionMode.UPDATE);
                    for (Content content : contentArray) {
                        session.insertContent(content);
                    }
                    session.commit();
                    session.setTransactionMode(Session.TransactionMode.QUERY);
                } else {
                    session.insertContent((Content[])contentArray);
                }
                if (!this.copyProperties) break;
                for (int i4 = 0; i4 < outputUri.length; ++i4) {
                    String properties;
                    if (ignoreList[i4] || null == (properties = metadata[i4].getProperties())) continue;
                    try {
                        System.out.println(">>> setting properties for " + outputUri[i4]);
                        session.setDocumentProperties(outputUri[i4], properties);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.logException("exception when setting properties", e);
                    }
                }
                break;
            }
            catch (XccException e) {
                if (--retries <= 0) {
                    throw new SyncException("write failed, all retries exhausted for " + outputUri[0], e);
                }
                this.logger.warning("error writing document (" + outputUri[0] + "), will retry " + retries + " more times.");
                sleepMillis = this.sleepForRetry(sleepMillis);
            }
        }
        if (this.configuration.useChecksumModule()) {
            try {
                String q = this.getQuery(outputUri.length);
                this.logger.fine("writer hash query = \n" + q);
                AdhocQuery req = session.newAdhocQuery(this.query);
                for (int i5 = 0; i5 < outputUri.length; ++i5) {
                    req.setNewStringVariable("URI-" + i5, outputUri[i5] == null ? "" : outputUri[i5]);
                }
                ResultSequence rs = session.submitRequest((Request)req);
                ResultItem[] items = rs.toResultItemArray();
                for (int i6 = 0; i6 < outputUri.length; ++i6) {
                    if (ignoreList[i6]) continue;
                    String srcHash = metadata[i6].getHashValue();
                    String dstHash = items[i6].asString();
                    if ((srcHash != null || dstHash == null) && srcHash.equals(dstHash)) continue;
                    this.logger.warning("hash value mismatch, uri = " + outputUri[i6] + ",src hash = " + srcHash + ",dst hash = " + dstHash);
                }
            }
            catch (Exception e) {
                this.logger.logException("hash comparison failed", e);
                for (String s : outputUri) {
                    this.logger.warning("no hash comparison for uri=" + s);
                }
            }
        }
        if (retries >= 0) {
            for (int i7 = 0; i7 < outputUri.length; ++i7) {
                if (ignoreList[i7]) continue;
                bytes += contentBytes[i7].length;
            }
        }
        session.close();
        return bytes;
    }

    private long sleepForRetry(long sleepMillis) {
        this.logger.fine("sleepMillis = " + sleepMillis);
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.logger.logException("interrupted during sleep " + sleepMillis, e);
        }
        return sleepMillis < 60000L ? 2L * sleepMillis : sleepMillis;
    }

    private boolean matchesFilters(String outputUri, MetadataInterface metadata) {
        if (null != this.outputFormatFilters && Arrays.binarySearch(this.outputFormatFilters, metadata.getFormatName()) > -1) {
            this.logger.finer("OUTPUT_FILTER_FORMATS matched " + outputUri);
            return true;
        }
        return false;
    }

    protected String getQuery(int uriCount) {
        if (this.query == null || uriCount != this.lastBatchSize) {
            int i;
            StringBuilder localQuery = new StringBuilder();
            String m = this.configuration.getChecksumModule();
            for (i = 0; i < uriCount; ++i) {
                localQuery.append("declare variable $URI-").append(i).append(" external;\n");
            }
            localQuery.append("\n");
            for (i = 0; i < uriCount; ++i) {
                localQuery.append("xdmp:invoke(\"").append(m).append("\", (xs:QName(\"URI\"), $URI-").append(i).append("))\n");
                if (i >= uriCount - 1) continue;
                localQuery.append(",\n");
            }
            this.query = localQuery.toString();
            this.lastBatchSize = uriCount;
        }
        return this.query;
    }
}

