/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.timing.TimedEvent;
import com.marklogic.ps.xqsync.CallableSync;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.Monitor;
import com.marklogic.ps.xqsync.OutputPackage;
import com.marklogic.ps.xqsync.PackageWriter;
import com.marklogic.ps.xqsync.ReaderInterface;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.WriterInterface;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

public class TaskFactory {
    protected SimpleLogger logger;
    protected final Configuration configuration;
    protected WriterInterface[] writers;
    protected String outputPackagePath;
    protected volatile int count = 0;
    protected Monitor monitor;

    public TaskFactory(Configuration config, Monitor monitor) throws SyncException {
        this.configuration = config;
        if (null == monitor) {
            throw new NullPointerException("monitor may not be null!");
        }
        this.monitor = monitor;
        this.logger = this.configuration.getLogger();
        this.outputPackagePath = config.getOutputPackagePath();
        if (null != this.outputPackagePath) {
            try {
                int threadCount = config.getThreadCount();
                int poolSize = Math.min(Runtime.getRuntime().availableProcessors(), threadCount);
                this.logger.info("creating " + poolSize + " writer(s)");
                this.writers = new WriterInterface[poolSize];
                String canonicalPath = new File(this.outputPackagePath).getCanonicalPath();
                for (int i = 0; i < poolSize; ++i) {
                    String path = OutputPackage.newPackagePath(canonicalPath, i, 3);
                    this.logger.fine("new writer " + path);
                    this.writers[i] = new PackageWriter(this.configuration, new OutputPackage(new File(path), this.configuration));
                }
            }
            catch (IOException e) {
                throw new SyncException(e);
            }
        }
    }

    public Callable<TimedEvent[]> newTask(String[] uris) {
        return new CallableSync(this, uris);
    }

    public void close() {
        if (null != this.writers && null != this.writers[0] && this.writers[0] instanceof PackageWriter) {
            this.logger.info("closing " + this.writers.length + " output package(s)");
            for (WriterInterface writer : this.writers) {
                if (null == writer) continue;
                ((PackageWriter)writer).close();
            }
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ReaderInterface getReader() throws SyncException {
        return this.configuration.newReader();
    }

    public WriterInterface getWriter() throws SyncException {
        WriterInterface writer = null;
        if (null != this.outputPackagePath) {
            writer = this.writers[this.count % this.writers.length];
            ++this.count;
        } else {
            writer = this.configuration.newWriter();
        }
        return writer;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }
}

