/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.timing.TimedEvent;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.Monitor;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.TaskFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UriQueue
extends Thread {
    protected static final long SLEEP_MILLIS = 125L;
    protected final Configuration configuration;
    protected volatile BlockingQueue<String> queue;
    protected final TaskFactory factory;
    protected final CompletionService<TimedEvent[]> completionService;
    protected boolean active;
    protected final ThreadPoolExecutor pool;
    protected final SimpleLogger logger;
    protected final Monitor monitor;
    protected boolean useQueueFile = false;
    protected File queueFile;
    protected PrintWriter queueFileWriter;
    protected BufferedReader queueFileReader;
    protected int queueFileEntries = 0;
    protected final Object queueFileMutex = new Object();

    public UriQueue(Configuration configuration, CompletionService<TimedEvent[]> cs, ThreadPoolExecutor pool, TaskFactory factory, Monitor monitor, BlockingQueue<String> queue) {
        super("UriQueueThread");
        this.configuration = configuration;
        this.pool = pool;
        this.factory = factory;
        this.monitor = monitor;
        this.queue = queue;
        this.completionService = cs;
        this.logger = configuration.getLogger();
        this.useQueueFile = configuration.useQueueFile();
    }

    @Override
    public void run() {
        this.active = true;
        long count = 0L;
        SimpleLogger logger = this.configuration.getLogger();
        String[] buffer = new String[this.configuration.getInputBatchSize()];
        int bufferIndex = 0;
        try {
            if (null == this.factory) {
                throw new SyncException("null factory");
            }
            if (null == this.completionService) {
                throw new SyncException("null completion service");
            }
            while (true) {
                String uri = null;
                if (this.useQueueFile) {
                    uri = this.getUriFromFile();
                } else {
                    try {
                        uri = this.queue.poll(125L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        logger.logException("interrupted", e);
                        Thread.currentThread().interrupt();
                        if (null == uri) continue;
                    }
                }
                if (null == uri) {
                    logger.finer(this + " uri null, active " + this.active);
                    if (!this.active) break;
                    if (!this.useQueueFile) continue;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                if (0L == count) {
                    logger.finest("took first uri: " + uri);
                }
                logger.finest(count + ": uri = " + uri);
                buffer[bufferIndex] = uri;
                if (buffer.length == ++bufferIndex) {
                    logger.finest("submitting " + buffer.length);
                    this.completionService.submit(this.factory.newTask(buffer));
                    buffer = new String[buffer.length];
                    bufferIndex = 0;
                    Thread.yield();
                }
                ++count;
            }
            logger.fine("cleaning up " + bufferIndex);
            if (bufferIndex > 0) {
                for (int i = bufferIndex; i < buffer.length; ++i) {
                    buffer[i] = null;
                }
                this.completionService.submit(this.factory.newTask(buffer));
                Thread.yield();
            }
        }
        catch (SyncException e) {
            logger.logException("fatal error", e);
            System.exit(1);
        }
        logger.finest("finished queuing " + count + " uris");
    }

    public synchronized void shutdown() {
        if (this.active) {
            this.logger.fine("closing queue " + this);
        }
        this.active = false;
    }

    public void halt() {
        this.logger.info("halting queue");
        this.queue = null;
        this.active = false;
        this.pool.shutdownNow();
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String uri) {
        Thread.yield();
        Object object = this.queueFileMutex;
        synchronized (object) {
            if (!this.useQueueFile) {
                this.queue.add(uri);
            } else {
                this.addUriToFile(uri);
                ++this.queueFileEntries;
            }
            this.monitor.incrementTaskCount();
        }
        Thread.yield();
    }

    public CompletionService<TimedEvent[]> getCompletionService() {
        return this.completionService;
    }

    public ThreadPoolExecutor getPool() {
        return this.pool;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public int getQueueSize() {
        if (this.useQueueFile) {
            return this.queueFileEntries;
        }
        return this.queue.size();
    }

    public boolean isActive() {
        return this.active;
    }

    private void addUriToFile(String uri) {
        if (null == this.queueFile) {
            try {
                if (this.configuration.getUriQueueFile() != null) {
                    this.queueFile = new File(this.configuration.getUriQueueFile());
                    if (this.queueFile.exists()) {
                        this.queueFile.delete();
                    }
                    this.queueFile.createNewFile();
                } else {
                    this.queueFile = this.configuration.getTmpDir() != null ? File.createTempFile("xqsync", ".txt", new File(this.configuration.getTmpDir())) : File.createTempFile("xqsync", ".txt");
                }
                if (!this.configuration.keepUriQueueFile()) {
                    this.queueFile.deleteOnExit();
                }
                this.queueFileWriter = new PrintWriter(this.queueFile);
                this.queueFileReader = new BufferedReader(new FileReader(this.queueFile));
            }
            catch (Exception e) {
                this.logger.logException("fatal error", e);
                System.exit(1);
            }
        }
        this.queueFileWriter.println(uri);
        this.queueFileWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUriFromFile() {
        String uri = null;
        Object object = this.queueFileMutex;
        synchronized (object) {
            try {
                if (this.queueFileReader != null) {
                    uri = this.queueFileReader.readLine();
                }
                if (null != uri) {
                    --this.queueFileEntries;
                }
            }
            catch (IOException e) {
                this.logger.logException("can't read uri queue file", e);
            }
        }
        return uri;
    }
}

