/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.FatalException;
import com.marklogic.ps.xqsync.XQSyncManager;
import com.marklogic.xcc.Version;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;

public class XQSync {
    public static final String VERSION = XQSync.class.getPackage().getImplementationVersion();
    private static final String VERSION_MESSAGE = "version " + VERSION + " on " + System.getProperty("java.version") + " (" + System.getProperty("java.runtime.name") + ")";

    public static void main(String[] args) throws Exception {
        String encoding = System.getProperty("file.encoding");
        if (!encoding.equals("UTF-8")) {
            throw new IOException("UTF-8 encoding is required: System property file.encoding " + encoding + " is not UTF-8. Change your locale, or set -Dfile.encoding=UTF-8");
        }
        Properties props = new Properties();
        for (String arg : args) {
            try (FileInputStream fileInputStream = new FileInputStream(arg);){
                props.load(fileInputStream);
            }
            System.err.println("loaded properties from " + arg);
        }
        props.putAll((Map<?, ?>)System.getProperties());
        System.err.println("added system properties");
        SimpleLogger logger = SimpleLogger.getSimpleLogger();
        logger.configureLogger(props);
        logger.info("XQSync starting: " + VERSION_MESSAGE);
        logger.info("XCC version = " + Version.getVersionString());
        Configuration configuration = XQSync.initConfiguration(logger, props);
        logger.info("XQSync starting: " + VERSION_MESSAGE);
        logger.info("XCC version = " + Version.getVersionString());
        long start = System.currentTimeMillis();
        XQSyncManager xqm = new XQSyncManager(configuration);
        xqm.run();
        long duration = System.currentTimeMillis() - start;
        long itemsQueued = xqm.getItemsQueued();
        logger.info("completed " + itemsQueued + " in " + duration + " ms (" + (int)(1000L * itemsQueued / duration) + " docs/s)");
    }

    public static synchronized Configuration initConfiguration(SimpleLogger logger, Properties properties) throws Exception {
        Configuration configuration = new Configuration();
        configuration.setLogger(null != logger ? logger : SimpleLogger.getSimpleLogger());
        configuration.setProperties(properties);
        try {
            String configClassName = configuration.getConfigurationClassName();
            logger.info("Configuration is " + configClassName);
            Class<Configuration> configurationClass = Class.forName(configClassName, true, XQSync.getClassLoader()).asSubclass(Configuration.class);
            Constructor<Configuration> configurationConstructor = configurationClass.getConstructor(new Class[0]);
            Properties props = configuration.getProperties();
            configuration = configurationConstructor.newInstance(new Object[0]);
            configuration.setProperties(props);
        }
        catch (Exception e) {
            throw new FatalException(e);
        }
        configuration.configure();
        return configuration;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = XQSync.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }
}

