/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.SimpleLogger;
import com.marklogic.ps.Utilities;
import com.marklogic.ps.xqsync.Configuration;
import com.marklogic.ps.xqsync.DocumentInterface;
import com.marklogic.ps.xqsync.MetadataInterface;
import com.marklogic.ps.xqsync.ReaderInterface;
import com.marklogic.ps.xqsync.SyncException;
import com.marklogic.ps.xqsync.WriterInterface;
import com.marklogic.ps.xqsync.XQSyncDocumentMetadata;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;

public class XQSyncDocument
implements DocumentInterface {
    public static final String UTF_8 = "UTF-8";
    public static final String ENCODING = "UTF-8";
    public static final String METADATA_EXT = ".metadata";
    public static final String METADATA_REGEX = "^.+\\.metadata$";
    protected final byte[][] contentBytes;
    protected final XQSyncDocumentMetadata[] metadata;
    protected SimpleLogger logger = null;
    protected final WriterInterface writer;
    protected final ReaderInterface reader;
    protected final Configuration configuration;
    protected final String[] inputUris;
    protected String[] outputUris;
    protected final boolean copyPermissions;
    protected final boolean copyProperties;

    public XQSyncDocument(String[] uris, ReaderInterface reader, WriterInterface writer, Configuration configuration) {
        this.inputUris = uris;
        this.reader = reader;
        this.writer = writer;
        this.configuration = configuration;
        this.logger = configuration.getLogger();
        this.copyPermissions = configuration.isCopyPermissions();
        this.copyProperties = configuration.isCopyProperties();
        this.metadata = new XQSyncDocumentMetadata[this.inputUris.length];
        this.contentBytes = new byte[this.inputUris.length][];
        this.composeOutputUris();
    }

    @Override
    public void setContent(int index, byte[] bytes) {
        this.contentBytes[index] = bytes;
    }

    @Override
    public void setMetadata(int index, Reader reader) {
        this.metadata[index] = XQSyncDocumentMetadata.fromXML(reader);
    }

    @Override
    public MetadataInterface newMetadata() {
        return new XQSyncDocumentMetadata();
    }

    @Override
    public int sync() throws SyncException {
        this.read();
        return this.write();
    }

    private int write() throws SyncException {
        String uri = null;
        int len = 0;
        for (int i = 0; i < this.outputUris.length; ++i) {
            if (null == this.inputUris[i]) continue;
            uri = this.outputUris[i];
            if (null == this.contentBytes[i]) {
                throw new NullPointerException("null content bytes at " + i + " (" + uri + "(");
            }
            if (null == this.metadata[i]) {
                throw new NullPointerException("null metadata at " + i + " (" + uri + "(");
            }
            if (this.contentBytes[i].length <= 2 || this.metadata[i].isBinary() || -17 != this.contentBytes[i][0] || -69 != this.contentBytes[i][1] || -65 != this.contentBytes[i][2]) continue;
            this.logger.finer("stripping BOM from " + uri);
            byte[] copy = new byte[this.contentBytes[i].length - 3];
            System.arraycopy(this.contentBytes[i], 3, copy, 0, copy.length);
            this.contentBytes[i] = copy;
        }
        len = this.writer.write(this.outputUris, this.contentBytes, this.metadata);
        return len;
    }

    public void read() throws SyncException {
        if (null != this.contentBytes[0]) {
            return;
        }
        this.reader.read(this.inputUris, this);
        for (int i = 0; i < this.metadata.length; ++i) {
            if (null == this.inputUris[i]) continue;
            if (null == this.metadata[i]) {
                throw new NullPointerException("unexpected empty metadata at " + i + ", " + this.inputUris[i]);
            }
            this.metadata[i].addCollections(this.configuration.getOutputCollections());
            if (!this.copyPermissions) {
                this.metadata[i].clearPermissions();
            }
            if (this.copyProperties) continue;
            this.metadata[i].clearProperties();
        }
    }

    public static File getMetadataFile(File contentFile) throws IOException {
        return new File(XQSyncDocument.getMetadataPath(contentFile));
    }

    public static String getMetadataPath(String path) {
        return path + METADATA_EXT;
    }

    public static String getMetadataPath(File file) throws IOException {
        return XQSyncDocument.getMetadataPath(file.getCanonicalPath());
    }

    private void composeOutputUris() {
        StringBuilder uriPrefix = new StringBuilder();
        if (this.configuration.getUriPrefix() != null) {
            uriPrefix.append(this.configuration.getUriPrefix());
        }
        String uriSuffix = this.configuration.getUriSuffix();
        String prefixStrip = this.configuration.getUriPrefixStrip();
        String suffixStrip = this.configuration.getUriSuffixStrip();
        this.outputUris = new String[this.inputUris.length];
        for (int i = 0; i < this.inputUris.length; ++i) {
            String uri = this.inputUris[i];
            if (null == uri) continue;
            if (null != prefixStrip && uri.startsWith(prefixStrip)) {
                uri = uri.substring(prefixStrip.length() - 1);
            }
            if (null != suffixStrip && uri.endsWith(suffixStrip)) {
                uri = uri.substring(0, uri.length() - suffixStrip.length() - 1);
            }
            if (!(null == uriPrefix || uriPrefix.toString().equals("") || uriPrefix.toString().endsWith("/") || uri.startsWith("/"))) {
                uriPrefix.append("/");
            }
            String innerUri = uri;
            if (this.configuration.useRandomOutputUri()) {
                innerUri = Long.toHexString(System.currentTimeMillis()) + Long.toHexString(this.hashCode()) + Long.toHexString(innerUri.hashCode());
            }
            String outputUri = (null == uriPrefix ? "" : uriPrefix.toString()) + innerUri + (null == uriSuffix ? "" : uriSuffix);
            if (this.configuration.encodeOutputUri()) {
                try {
                    URI uriObj = new URI(null, null, outputUri, null, null);
                    outputUri = uriObj.toString();
                }
                catch (URISyntaxException e) {
                    this.logger.logException("invalid uri", e);
                }
            }
            this.logger.finer("copying " + uri + " to " + outputUri);
            this.outputUris[i] = outputUri;
        }
    }

    @Override
    public void setMetadata(int index, MetadataInterface metadata) {
        this.metadata[index] = (XQSyncDocumentMetadata)metadata;
    }

    @Override
    public void setContent(int index, InputStream is) throws SyncException {
        try {
            this.contentBytes[index] = Utilities.cat(is);
        }
        catch (IOException e) {
            throw new SyncException(e);
        }
    }

    @Override
    public void setContent(int index, Reader reader) throws SyncException {
        try {
            this.contentBytes[index] = Utilities.cat(reader).getBytes();
        }
        catch (IOException e) {
            throw new SyncException(e);
        }
    }

    @Override
    public String getOutputUri(int index) {
        return this.outputUris[index];
    }

    @Override
    public void clearPermissions(int index) {
        this.metadata[index].clearPermissions();
    }

    @Override
    public void clearProperties(int index) {
        this.metadata[index].clearProperties();
    }

    public byte[] getContent(int index) {
        return this.contentBytes[index];
    }

    public XQSyncDocumentMetadata getMetadata(int index) {
        return this.metadata[index];
    }
}

