/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.ps.xqsync;

import com.marklogic.ps.xqsync.MetadataInterface;
import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.exceptions.UnimplementedFeatureException;
import com.marklogic.xcc.types.XSInteger;
import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class XQSyncDocumentMetadata
implements MetadataInterface {
    static final XStream xstream = new XStream();
    DocumentFormat format = DocumentFormat.XML;
    final List<String> collectionsList = new ArrayList<String>();
    final List<ContentPermission> permissionsList = new ArrayList<ContentPermission>();
    int quality = 0;
    String properties = null;
    protected String hashValue = null;

    public static XQSyncDocumentMetadata fromXML(Reader reader) {
        return (XQSyncDocumentMetadata)xstream.fromXML(reader);
    }

    @Override
    public boolean isBinary() {
        return DocumentFormat.BINARY.toString().equals(this.format.toString());
    }

    public void setFormat(DocumentFormat format) {
        this.format = format;
    }

    @Override
    public void addCollection(String collection) {
        this.collectionsList.add(collection);
    }

    public void addPermission(ContentPermission permission) {
        this.permissionsList.add(permission);
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    public void setProperties(String properties) {
        this.properties = properties;
    }

    public String[] getCollections() {
        return this.collectionsList.toArray(new String[0]);
    }

    public String getProperties() {
        return this.properties;
    }

    public void addPermissions(Collection<ContentPermission> permissions) {
        if (permissions == null) {
            return;
        }
        this.permissionsList.addAll(permissions);
    }

    public ContentPermission[] getPermissions() {
        if (this.permissionsList.isEmpty()) {
            return new ContentPermission[0];
        }
        return this.permissionsList.toArray(new ContentPermission[0]);
    }

    public int getQuality() {
        return this.quality;
    }

    public DocumentFormat getFormat() {
        return this.format;
    }

    public String toXML() {
        return xstream.toXML((Object)this);
    }

    @Override
    public void clearPermissions() {
        this.permissionsList.clear();
    }

    @Override
    public void clearProperties() {
        this.properties = null;
    }

    @Override
    public String getFormatName() {
        return this.format.toString();
    }

    @Override
    public void setFormat(String format) {
        if (DocumentFormat.XML.toString().equals(format) || "element".equals(format) || "comment".equals(format) || "processing-instruction".equals(format)) {
            this.setFormat(DocumentFormat.XML);
            return;
        }
        if (DocumentFormat.TEXT.toString().equals(format) || "text".equals(format)) {
            this.setFormat(DocumentFormat.TEXT);
            return;
        }
        this.setFormat(DocumentFormat.BINARY);
    }

    @Override
    public void addPermission(String capability, String role) {
        ContentCapability contentCapability;
        if (ContentPermission.UPDATE.toString().equals(capability)) {
            contentCapability = ContentPermission.UPDATE;
        } else if (ContentPermission.INSERT.toString().equals(capability)) {
            contentCapability = ContentPermission.INSERT;
        } else if (ContentPermission.EXECUTE.toString().equals(capability)) {
            contentCapability = ContentPermission.EXECUTE;
        } else if (ContentPermission.READ.toString().equals(capability)) {
            contentCapability = ContentPermission.READ;
        } else {
            throw new UnimplementedFeatureException("unknown capability: " + capability);
        }
        this.addPermission(new ContentPermission(contentCapability, role));
    }

    @Override
    public void setQuality(XSInteger integer) {
        this.setQuality(integer.asPrimitiveInt());
    }

    public boolean isText() {
        return DocumentFormat.TEXT.toString().equals(this.format.toString());
    }

    public boolean isXml() {
        return DocumentFormat.XML.toString().equals(this.format.toString());
    }

    public void addCollections(String[] collections) {
        if (null == collections || 1 > collections.length) {
            return;
        }
        for (String collection : collections) {
            this.addCollection(collection);
        }
    }

    @Override
    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    @Override
    public String getHashValue() {
        return this.hashValue;
    }
}

