/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.hex;

import com.martiansoftware.hex.HexDecoderAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.function.Predicate;

public class CharIgnoringHexDecoder
extends HexDecoderAdapter {
    private final Predicate<Character> _shouldIgnore;

    public CharIgnoringHexDecoder(String charsToIgnore) {
        this(charsToIgnore.toCharArray());
    }

    public CharIgnoringHexDecoder(char[] charsToIgnore) {
        HashSet<Character> toIgnore = new HashSet<Character>();
        for (char c2 : charsToIgnore) {
            toIgnore.add(Character.valueOf(c2));
        }
        this._shouldIgnore = c -> toIgnore.contains(c);
    }

    public CharIgnoringHexDecoder(Predicate<Character> shouldIgnore) {
        this._shouldIgnore = shouldIgnore;
    }

    @Override
    protected HexDecoderAdapter.Strategy newStrategy() {
        return new CharIgnoringStrategy();
    }

    private class CharIgnoringStrategy
    implements HexDecoderAdapter.Strategy {
        private CharIgnoringStrategy() {
        }

        @Override
        public void start(OutputStream out) throws IOException {
        }

        @Override
        public boolean shouldIgnore(char c, long charIndexInStream, long charIndexInLine, OutputStream out) throws ParseException, IOException {
            return CharIgnoringHexDecoder.this._shouldIgnore.test(Character.valueOf(c));
        }

        @Override
        public void finish(long totalChars, long totalBytes, OutputStream out) throws ParseException, IOException {
        }
    }
}

