/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.hex;

import com.martiansoftware.hex.Hex;
import com.martiansoftware.hex.HexEncoderAdapter;
import com.martiansoftware.validation.Hope;
import java.io.PrintWriter;

public class DelimitedMultilineHexEncoder
extends HexEncoderAdapter {
    private final int _bytesPerLine;
    private final String _separator;

    public DelimitedMultilineHexEncoder() {
        this(Integer.MAX_VALUE, null);
    }

    public DelimitedMultilineHexEncoder(int bytesPerLine) {
        this(bytesPerLine, null);
    }

    public DelimitedMultilineHexEncoder(String separator) {
        this(Integer.MAX_VALUE, separator);
    }

    public DelimitedMultilineHexEncoder(int bytesPerLine, String separator) {
        this._bytesPerLine = (Integer)Hope.that((Object)bytesPerLine).named("bytesPerLine").isTrue(b -> b > 0, "bytesPerLine must be greater than zero", new Object[0]).value();
        this._separator = separator;
    }

    @Override
    protected HexEncoderAdapter.Strategy newStrategy() {
        return new SimpleByteHandler();
    }

    private class SimpleByteHandler
    implements HexEncoderAdapter.Strategy {
        private SimpleByteHandler() {
        }

        @Override
        public void start(PrintWriter p) {
        }

        private void writeSeparator(PrintWriter w) {
            if (DelimitedMultilineHexEncoder.this._separator != null) {
                w.print(DelimitedMultilineHexEncoder.this._separator);
            }
        }

        @Override
        public void next(int b, long byteIndexInStream, PrintWriter p) {
            if (byteIndexInStream % (long)DelimitedMultilineHexEncoder.this._bytesPerLine == 0L) {
                if (byteIndexInStream > 0L) {
                    p.println();
                }
            } else {
                this.writeSeparator(p);
            }
            p.print(Hex.of(b));
        }

        @Override
        public void finish(long totalBytes, PrintWriter p) {
        }
    }
}

