/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.hex;

import com.martiansoftware.hex.HexDecoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.text.ParseException;

public abstract class HexDecoderAdapter
implements HexDecoder {
    private static final int CR = 13;
    private static final int LF = 10;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void decode(Reader in, OutputStream out) throws IOException, ParseException {
        Strategy o = this.newStrategy();
        o.start(out);
        State state = State.NEEDS_DIGIT_1;
        long charIndexInStream = -1L;
        long charIndexInLine = 0L;
        long totalBytes = 0L;
        int b = 0;
        block4: while (true) {
            int c = in.read();
            ++charIndexInStream;
            charIndexInLine = c == 13 || c == 10 ? 0L : ++charIndexInLine;
            switch (state) {
                case NEEDS_DIGIT_1: {
                    if (c == -1) break block4;
                    if (o.shouldIgnore((char)c, charIndexInStream, charIndexInLine, out)) continue block4;
                    b = 16 * this.valueOf((char)c, charIndexInStream);
                    state = State.NEEDS_DIGIT_2;
                    break;
                }
                case NEEDS_DIGIT_2: {
                    if (c == -1) {
                        throw new ParseException(String.format("unexpected eof at position %d", charIndexInStream), (int)charIndexInStream);
                    }
                    out.write(b += this.valueOf((char)c, charIndexInStream));
                    state = State.NEEDS_DIGIT_1;
                }
            }
        }
        o.finish(charIndexInStream, totalBytes, out);
    }

    protected int valueOf(char c, long index) throws ParseException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new ParseException(String.format("invalid character '%c' at position %d", Character.valueOf(c), index), (int)index);
    }

    protected abstract Strategy newStrategy();

    public static interface Strategy {
        public void start(OutputStream var1) throws IOException;

        public boolean shouldIgnore(char var1, long var2, long var4, OutputStream var6) throws ParseException, IOException;

        public void finish(long var1, long var3, OutputStream var5) throws ParseException, IOException;
    }

    private static enum State {
        NEEDS_DIGIT_1,
        NEEDS_DIGIT_2;

    }
}

