/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.hex;

import com.martiansoftware.hex.Hex;
import com.martiansoftware.hex.HexEncoderAdapter;
import java.io.PrintWriter;

public class HexDumpEncoder
extends HexEncoderAdapter {
    @Override
    protected HexEncoderAdapter.Strategy newStrategy() {
        return new DumpStrategy();
    }

    private class DumpStrategy
    implements HexEncoderAdapter.Strategy {
        private long _address = 0L;
        private final StringBuilder _buf = new StringBuilder();
        private final StringBuilder _asciiBuf = new StringBuilder();

        private DumpStrategy() {
        }

        @Override
        public void start(PrintWriter out) {
        }

        private void flush(PrintWriter out) {
            if (this._address > 0L) {
                out.println();
            }
            while (this._buf.length() < 62) {
                this._buf.append(' ');
            }
            while (this._asciiBuf.length() < 16) {
                this._asciiBuf.append(' ');
            }
            out.print(this._buf.toString());
            out.print(this._asciiBuf.toString());
            out.flush();
            this._address += 16L;
            this._buf.setLength(0);
            this._asciiBuf.setLength(0);
        }

        private char ascii(int b) {
            if (b < 32 || b > 126) {
                return '.';
            }
            return (char)b;
        }

        @Override
        public void next(int b, long byteIndexInStream, PrintWriter out) {
            long indexInLine = byteIndexInStream % 16L;
            if (indexInLine == 0L) {
                if (byteIndexInStream > 0L) {
                    this.flush(out);
                }
                this._buf.append(String.format("%08x: ", this._address));
            }
            if (indexInLine == 8L) {
                this._buf.append("  ");
            }
            this._buf.append(Hex.of(b));
            this._buf.append(' ');
            this._asciiBuf.append(this.ascii(b));
        }

        @Override
        public void finish(long totalBytes, PrintWriter out) {
            if (this._asciiBuf.length() > 0) {
                this.flush(out);
            }
        }
    }
}

