/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.hex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public interface HexEncoder {
    default public String encode(byte[] b) {
        return this.encode(b, 0, b.length);
    }

    default public String encode(byte[] b, int offset, int len) {
        try {
            return this.encode(new ByteArrayInputStream(b, offset, len));
        }
        catch (IOException notExpected) {
            throw new RuntimeException(notExpected);
        }
    }

    default public String encode(InputStream in) throws IOException {
        StringWriter s = new StringWriter();
        try (PrintWriter p = new PrintWriter(s);){
            this.encode(in, p);
        }
        return s.toString();
    }

    default public void encode(byte[] b, PrintWriter out) {
        this.encode(b, 0, b.length, out);
    }

    default public void encode(byte[] b, PrintStream out) {
        try (PrintWriter p = new PrintWriter(out);){
            this.encode(b, p);
        }
    }

    default public void encode(byte[] b, int offset, int len, PrintWriter out) {
        try {
            this.encode((InputStream)new ByteArrayInputStream(b, offset, len), out);
        }
        catch (IOException notExpected) {
            throw new RuntimeException(notExpected);
        }
    }

    default public void encode(byte[] b, int offset, int len, PrintStream out) {
        try (PrintWriter p = new PrintWriter(out);){
            this.encode(b, offset, len, p);
        }
    }

    default public void encode(InputStream in, PrintStream out) throws IOException {
        try (PrintWriter p = new PrintWriter(out);){
            this.encode(in, p);
        }
    }

    public void encode(InputStream var1, PrintWriter var2) throws IOException;
}

