/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="easy-jacoco")
@Singleton
public class EasyJacocoLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger log = LoggerFactory.getLogger(EasyJacocoLifecycleParticipant.class);
    @Inject
    private ModelWriter modelWriter;
    @Inject
    private ProjectBuilder projectBuilder;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        if ("true".equalsIgnoreCase(System.getProperty("easyjacoco.skip"))) {
            log.info("Skipping EasyJacoco lifecycle logic due to -Deasyjacoco.skip=true");
            return;
        }
        log.info("Registering jacoco related plugins on all modules");
        for (MavenProject project : session.getProjects()) {
            this.registerVanillaJacocoExecution(project);
        }
        MavenProject topLevelProject = session.getTopLevelProject();
        if (session.getProjects().size() > 1) {
            log.debug("Detected multi-module project, registering project report");
            MavenProject reportProject = this.newReportProject(topLevelProject, session.getProjects(), session.getProjectBuildingRequest());
            ArrayList<MavenProject> allProjects = new ArrayList<MavenProject>(session.getProjects());
            allProjects.add(reportProject);
            session.setProjects(allProjects);
        }
    }

    private MavenProject newReportProject(MavenProject topLevelProject, List<MavenProject> reactorProjects, ProjectBuildingRequest projectBuildingRequest) throws MavenExecutionException {
        String projectArtifactId = topLevelProject.getArtifactId().contains("-parent") ? topLevelProject.getArtifactId().replace("-parent", "-coverage") : topLevelProject.getArtifactId() + "-coverage";
        File outputDir = new File(topLevelProject.getBuild().getDirectory());
        File coverageProjectDir = new File(outputDir, projectArtifactId);
        File generatedPom = new File(coverageProjectDir, "pom.xml");
        if (!coverageProjectDir.exists() && !coverageProjectDir.mkdirs()) {
            throw new MavenExecutionException("Failed to create output dir for coverage pom", generatedPom);
        }
        try {
            log.info("Generating report project: " + projectArtifactId);
            Model pom = new Model();
            pom.setModelVersion(topLevelProject.getModelVersion());
            Parent parent = new Parent();
            parent.setGroupId(topLevelProject.getGroupId());
            parent.setArtifactId(topLevelProject.getArtifactId());
            parent.setVersion(topLevelProject.getVersion());
            pom.setGroupId(topLevelProject.getGroupId());
            pom.setParent(parent);
            pom.setVersion(topLevelProject.getVersion());
            pom.setPackaging("pom");
            pom.setArtifactId(projectArtifactId);
            Properties extraProperties = this.readExtraProperties(topLevelProject);
            pom.setProperties(extraProperties);
            Build build = new Build();
            build.setOutputDirectory(topLevelProject.getBuild().getOutputDirectory());
            pom.setBuild(build);
            Properties pluginProps = EasyJacocoLifecycleParticipant.readArtifactProperties("com.marvinformatics.jacoco", "easy-jacoco-maven-plugin");
            Plugin plugin = new Plugin();
            plugin.setGroupId("com.marvinformatics.jacoco");
            plugin.setArtifactId("easy-jacoco-maven-plugin");
            plugin.setVersion(pluginProps.getProperty("version"));
            PluginExecution report = new PluginExecution();
            report.setId("report-project");
            report.setGoals(List.of("report-project"));
            PluginExecution check = new PluginExecution();
            check.setId("check-project");
            check.setGoals(List.of("check-project"));
            Xpp3Dom configuration = new Xpp3Dom("configuration");
            configuration.addChild(this.newPair("reportGroupId", pom.getGroupId()));
            configuration.addChild(this.newPair("reportArtifactId", pom.getArtifactId()));
            configuration.addChild(this.newPair("reportVersion", pom.getVersion()));
            PluginExecution persist = new PluginExecution();
            persist.setId("persist-report-project");
            persist.setGoals(List.of("persist-report-project"));
            persist.setConfiguration((Object)configuration);
            plugin.setExecutions(List.of(report, check, persist));
            build.setPlugins(List.of(plugin));
            List dependencies = reactorProjects.stream().filter(reactorProject -> !reactorProject.equals((Object)topLevelProject)).map(dep -> this.toDependency((MavenProject)dep)).collect(Collectors.toList());
            pom.setDependencies(dependencies);
            this.modelWriter.write(generatedPom, null, pom);
            return this.projectBuilder.build(generatedPom, projectBuildingRequest).getProject();
        }
        catch (Exception e) {
            throw new MavenExecutionException("Failed to generate coverage pom.", (Throwable)e);
        }
    }

    private Properties readExtraProperties(MavenProject topLevelProject) {
        Plugin plugin = topLevelProject.getPlugin("com.marvinformatics.jacoco:easy-jacoco-maven-plugin");
        if (plugin == null) {
            return new Properties();
        }
        if (!(plugin.getConfiguration() instanceof Xpp3Dom)) {
            return new Properties();
        }
        Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom projectExtraProperties = config.getChild("projectExtraProperties");
        if (projectExtraProperties == null || projectExtraProperties.getChildCount() == 0) {
            return new Properties();
        }
        Properties properties = new Properties();
        for (Xpp3Dom child : projectExtraProperties.getChildren()) {
            properties.setProperty(child.getName(), child.getValue());
        }
        return properties;
    }

    private Dependency toDependency(MavenProject project) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(project.getGroupId());
        dependency.setArtifactId(project.getArtifactId());
        dependency.setVersion(project.getVersion());
        dependency.setType(project.getPackaging());
        return dependency;
    }

    private Plugin registerVanillaJacocoExecution(MavenProject project) throws MavenExecutionException {
        Properties jacocoPomProps = EasyJacocoLifecycleParticipant.readArtifactProperties("org.jacoco", "org.jacoco.core");
        Plugin plugin = project.getPlugin("org.jacoco:jacoco-maven-plugin");
        if (plugin == null) {
            plugin = new Plugin();
            plugin.setGroupId("org.jacoco");
            plugin.setArtifactId("jacoco-maven-plugin");
            plugin.setVersion(jacocoPomProps.getProperty("version"));
            project.getBuild().addPlugin(plugin);
        }
        PluginExecution execution = new PluginExecution();
        execution.setId("vanilla-jacoco-goals");
        execution.setGoals(List.of("prepare-agent", "prepare-agent-integration", "report", "report-integration"));
        plugin.setExecutions(Collections.singletonList(execution));
        return plugin;
    }

    private Xpp3Dom newPair(String name, String value) {
        Xpp3Dom dom = new Xpp3Dom(name);
        dom.setValue(value);
        return dom;
    }

    public static Properties readArtifactProperties(String groupId, String artifactId) throws MavenExecutionException {
        Properties properties;
        block9: {
            String resource = "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
            InputStream stream = EasyJacocoLifecycleParticipant.class.getResourceAsStream(resource);
            try {
                if (stream == null) {
                    throw new MavenExecutionException("Properties not found for " + groupId + ":" + artifactId, (Throwable)new IOException());
                }
                Properties props = new Properties();
                props.load(stream);
                properties = props;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MavenExecutionException("Unable to read properties for " + groupId + ":" + artifactId, (Throwable)e);
                }
            }
            stream.close();
        }
        return properties;
    }
}

