/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.easyjacoco;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;
import org.jacoco.core.runtime.WildcardMatcher;

@Mojo(name="instrument-jar", defaultPhase=LifecyclePhase.PACKAGE)
public class InstrumentJarMojo
extends AbstractMojo {
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    @Parameter(property="easyjacoco.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="easyjacoco.source", required=true)
    private File source;
    @Parameter(property="easyjacoco.destination", required=true)
    private File destination;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Instrumentation skipped via skip configuration");
            return;
        }
        this.getLog().info((CharSequence)("Instrumenting file: " + this.source.getAbsolutePath()));
        if (this.source.equals(this.destination)) {
            this.source = new File(this.source.getParentFile(), this.source.getName() + ".original");
            this.getLog().info((CharSequence)("In place instrumentation, renamed original file to: " + String.valueOf(this.source)));
            this.destination.renameTo(this.source);
        }
        if (this.destination.exists()) {
            this.destination.delete();
        }
        if (this.includes == null) {
            this.includes = List.of("**/*.class");
        }
        if (this.excludes == null) {
            this.excludes = List.of();
        }
        final WildcardMatcher includes = new WildcardMatcher(this.includes.stream().collect(Collectors.joining(":")));
        final WildcardMatcher excludes = new WildcardMatcher(this.excludes.stream().collect(Collectors.joining(":")));
        Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator()){

            public byte[] instrument(byte[] buffer, String name) throws IOException {
                String classname = name.split("@")[1];
                if (includes.matches(classname) && !excludes.matches(classname)) {
                    InstrumentJarMojo.this.getLog().debug((CharSequence)String.format("Instrumenting class %s", classname));
                    return super.instrument(buffer, classname);
                }
                InstrumentJarMojo.this.getLog().debug((CharSequence)String.format("Skip instrumentation for %s", classname));
                return buffer;
            }
        };
        this.destination.getParentFile().mkdirs();
        try (FileInputStream input = new FileInputStream(this.source);
             FileOutputStream output = new FileOutputStream(this.destination);){
            instrumenter.instrumentAll((InputStream)input, (OutputStream)output, this.source.getAbsolutePath());
            this.getLog().info((CharSequence)("Instrumented jar saved to: " + this.destination.getAbsolutePath()));
        }
        catch (IOException e) {
            this.destination.delete();
            throw new MojoExecutionException((Throwable)e);
        }
    }
}

